package com.liquidnet.client.admin.zhengzai.smile.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.time.LocalDate;

@Data
public class SmileUserVo {

    private Long id;

    @ApiModelProperty("uid")
    private String uid;

    /**
     * 照片
     */
    @ApiModelProperty("照片d")
    private String img;

    /**
     * 真实姓名
     */
    @ApiModelProperty("真实姓名")
    private String name;

    /**
     * 生日YYYY-MM-DD
     */
    @ApiModelProperty("生日")
    private LocalDate birthday;

    /**
     * 性别(1：男（默认），2：女)
     */
    @ApiModelProperty("性别(1：男（默认），2：女)")
    private Integer sex;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String phone;

    /**
     * 省Id
     */
    @ApiModelProperty("省Id")
    private String provinceId;

    /**
     * 省
     */
    @ApiModelProperty("省")
    private String province;

    /**
     * 市Id
     */
    @ApiModelProperty("市Id")
    private String cityId;

    /**
     * 市
     */
    @ApiModelProperty("市")
    private String city;

    /**
     * 区Id
     */
    @ApiModelProperty("区Id")
    private String areaId;

    /**
     * 区
     */
    @ApiModelProperty("区")
    private String area;

    /**
     * 详细地址
     */
    @ApiModelProperty("详细地址")
    private String address;

    /**
     * 微信号
     */
    @ApiModelProperty("微信号")
    private String wechat;

    /**
     * 代理类型（1：总代，2：普代）
     */
    @ApiModelProperty("代理类型（1：总代，2：普代）")
    private Integer type;

    /**
     * 组织关联
     */
    @ApiModelProperty("组织关联")
    private Long orgId;

    /**
     * 身份证号
     */
    @ApiModelProperty("身份证号")
    private String idCard;

    /**
     * 学校ID
     */
    @ApiModelProperty("学校ID")
    private String schoolId;

    /**
     * 学校名称
     */
    @ApiModelProperty("学校名称")
    private String schoolName;

    /**
     * 专业
     */
    @ApiModelProperty("专业")
    private String schoolMajor;

    /**
     * 身份（1:在校学生（默认），2已毕业）
     */
    @ApiModelProperty("身份（1:在校学生（默认），2已毕业）")
    private Integer identity;

    /**
     * 标识步骤
     */
    @ApiModelProperty("标识步骤")
    private String tag;

    /**
     * 认证标识（0:未审核，1：通过，2：未通过）
     */
    @ApiModelProperty("认证标识（0:未审核，1：通过，2：未通过）")
    private Integer authTag;

    /**
     * 认证失败原因
     */
    @ApiModelProperty("认证失败原因")
    private String errorReason;

    /**
     * 1：代理开启，2：代理关闭
     */
    @ApiModelProperty("uid")
    private Integer agent;

    /**
     * 自我介绍
     */
    @ApiModelProperty("自我介绍")
    private String introduce;

    /**
     * 擅长1
     */
    @ApiModelProperty("擅长1")
    private String specialty1;

    /**
     * 擅长2
     */
    @ApiModelProperty("擅长2")
    private String specialty2;

    /**
     * 擅长3
     */
    @ApiModelProperty("擅长3")
    private String specialty3;
}
