package com.liquidnet.service.adam.test;

import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserMemberVo;
import com.liquidnet.service.base.SqlMapping;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestRabbitMq
 * @Package com.liquidnet.service.adam.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/6/24 14:18
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestRabbitMq {
    @Autowired
    RabbitTemplate rabbitTemplate;

    @Test
    public void testRibbitMqConn(){
        LocalDateTime now = LocalDateTime.now();
        LinkedList<String> toMqSqls = new LinkedList<>();
        toMqSqls.add(SqlMapping.get("adam_user.close"));
        LinkedList<Object[]> objsUser = new LinkedList<>();
        objsUser.add(new Object[]{now, now, "0001"});
        objsUser.add(new Object[]{now, now, "0002"});
        objsUser.add(new Object[]{now, now, "0003"});
        for(int i=0;i<100000;i++){
            try {
                Thread.sleep(200l);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            objsUser.add(new Object[]{now, now, "000"+i});
        }
        long s = System.currentTimeMillis();
        rabbitTemplate.convertAndSend(MQConst.EX_LNS_SQL_UCENTER, MQConst.RK_SQL_UCENTER,
                SqlMapping.gets(toMqSqls, objsUser));
        log.debug("#MQ耗时:{}ms", System.currentTimeMillis() - s);
    }
}
