package com.liquidnet.service.kylin.dto.param.ticketSystem;

import com.liquidnet.service.kylin.dto.vo.ticketSystem.RefundOrderVo;
import com.liquidnet.service.kylin.dto.vo.ticketSystem.STFieldListVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "STRefundOrderParam", description = "详情")
public class STRefundOrderParam implements Cloneable{
    @ApiModelProperty(value = "退单订单id [必传]")
    String refundOrderId;
    @ApiModelProperty(value = "订单id [必传]")
    String orderId;
    @ApiModelProperty(value = "退单原因 [必传]")
    String reason;
    @ApiModelProperty(value = "退单时间 [必传]")
    LocalDateTime refundOrderTime;
    @ApiModelProperty(value = "票单List [必传]")
    List<RefundOrderVo> ticketOrderList;

    private static final STRefundOrderParam obj = new STRefundOrderParam();

    public static STRefundOrderParam getNew() {
        try {
            return (STRefundOrderParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new STRefundOrderParam();
    }
}