package com.liquidnet.service.chime.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserTagsMappingVo
 * @Package com.liquidnet.service.chime.vo.mongo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/3 16:50
 */
@ApiModel(value = "ChimeUserTagDto", description = "社交用户标签")
@Data
public class ChimeUserTagDto {
    private static final long serialVersionUID = 5325511589667456214L;
    @ApiModelProperty(position = 0, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 1, value = "标签code")
    private String tagCode;
    @ApiModelProperty(position = 2, value = "标签描述")
    private String tagDesc;

    private static final ChimeUserTagDto obj = new ChimeUserTagDto();
    public static ChimeUserTagDto getNew() {
        try {
            return (ChimeUserTagDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new ChimeUserTagDto();
        }
    }
}
