package com.liquidnet.service.chime.vo.mongo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserTagsMappingVo
 * @Package com.liquidnet.service.chime.vo.mongo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/3 16:50
 */
@ApiModel(value = "ChimeUserInfoVo", description = "社交用户信息")
@Data
public class ChimeUserInfoVo {
    private String mid;
    private static final long serialVersionUID = 5325511589667456213L;
    @ApiModelProperty(position = 0, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 1, value = "性别")
    private String sex;
    @ApiModelProperty(position = 2, value = "用户昵称")
    private String userName;
    @ApiModelProperty(position = 3, value = "用户手机号")
    private String userMobile;
    @ApiModelProperty(position = 4, value = "头像")
    private String avatar;
    @ApiModelProperty(position = 5, value = "在场ID")
    private String joinPerformanceId;

    private static final ChimeUserInfoVo obj = new ChimeUserInfoVo();
    public static ChimeUserInfoVo getNew() {
        try {
            return (ChimeUserInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new ChimeUserInfoVo();
        }
    }
}
