package com.liquidnet.service.chime.controller;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.chime.dto.ChimeUserInfoDto;
import com.liquidnet.service.chime.dto.ChimeUserListQueryReqDto;
import com.liquidnet.service.chime.dto.PerformanceDto;
import com.liquidnet.service.chime.service.IChimePerformanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 演出相关
 * @class: ChimePerformanceController
 * @Package com.liquidnet.service.chime.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/6 11:43
 */
@Api(tags = "在场-演出相关")
@RestController
@RequestMapping("performance")
@Validated
public class ChimePerformanceController {
    @Autowired
    private IChimePerformanceService chimePerformanceService;

    @GetMapping("myPerformanceList")
    @ApiOperation("已购票的演出")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(type = "query", dataType = "int", name = "page", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "size", value = "每页数量"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间timeStart"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<List<PerformanceDto>> myPerformanceList(
            @RequestParam(defaultValue = "") String userId,
            @RequestParam(defaultValue = "1") int page,
            @RequestParam(defaultValue = "10") int size,
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {
        List<PerformanceDto> performanceDtoList = new ArrayList<>();
        for(int i=0;i<10;i++){
            PerformanceDto dto = PerformanceDto.getNew();
            dto.setPerformancesId(IDGenerator.get32UUID());
            dto.setTitle("已购票演出00"+(i+1));
            dto.setImgPoster("https://img.zhengzai.tv/other/2021/08/04/865b8c442e7c4fb6a9f3d9b17a8e5b80.jpg");
            dto.setTimeStart("2021-09-08 12:00:00");
            dto.setTimeEnd("2021-10-08 12:00:00");
            dto.setCityName("北京");
            dto.setJoinUserCount(123+(i*2));
            performanceDtoList.add(dto);
        }
//        HashMap<String, Object> result = kylinPerformancesService.localList(
//                days, cityName, type,
//                isDiscount, isAdvance, isExclusive,
//                orderBy, sort
//        );
        return ResponseDto.success(performanceDtoList);
    }

    @GetMapping("localPerformanceList")
    @ApiOperation("本地最近演出列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "cityName", value = "城市名称", required = true),
            @ApiImplicitParam(type = "query", dataType = "int", name = "page", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "size", value = "每页数量"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间timeStart"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<List<PerformanceDto>> localPerformanceList(
            @RequestParam(defaultValue = "") String cityName,
            @RequestParam(defaultValue = "") String userId,
            @RequestParam(defaultValue = "1") int page,
            @RequestParam(defaultValue = "10") int size,
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {
        List<PerformanceDto> performanceDtoList = new ArrayList<>();
        for(int i=0;i<10;i++){
            PerformanceDto dto = PerformanceDto.getNew();
            dto.setPerformancesId(IDGenerator.get32UUID());
            dto.setTitle("本地最近演出00"+(i+1));
            dto.setImgPoster("https://img.zhengzai.tv/files/2021/03/09/604705d6b1147.jpeg");
            dto.setTimeStart("2021-09-08 12:00:00");
            dto.setTimeEnd("2021-10-08 12:00:00");
            dto.setCityName("北京");
            dto.setJoinUserCount(123+(i*2));
            performanceDtoList.add(dto);
        }
        return ResponseDto.success(performanceDtoList);
    }

    @GetMapping("getUserListByCon")
    @ApiOperation("查询用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sex", value = "性别"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "pageNum", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "pageSize", value = "每页数量"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "tags", value = "兴趣标签"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间timeStart"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<PagedResult<ChimeUserInfoDto>> getUserListByCon(
            @RequestParam(defaultValue = "") String performanceId,
            @RequestParam(defaultValue = "") String sex,
            @RequestParam(defaultValue = "1") int pageNum,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(defaultValue = "") String tags,
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {
        ChimeUserListQueryReqDto reqDto = ChimeUserListQueryReqDto.getNew();
        reqDto.setPerformanceId(performanceId);
        reqDto.setPageNum(pageNum);
        reqDto.setPageSize(pageSize);
        reqDto.setOrderItem(orderBy);
        reqDto.setOrderSc(sort);
        reqDto.setSex(sex);
        reqDto.setTags(tags);
//        PageInfo<ChimeUserInfoDto> pageInfo = chimePerformanceService.getUserListByCon(reqDto);
        PagedResult<ChimeUserInfoDto> pageInfo = chimePerformanceService.getUserListByCon(reqDto);
        return ResponseDto.success(pageInfo);
    }

}
