package com.liquidnet.service.chime.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.chime.vo.mongo.ChimeUserInfoVo;
import com.liquidnet.service.chime.vo.mongo.ChimeUserTagsMappingVo;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;

@Slf4j
@Component
public class DataUtils {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RedisUtil redisUtil;

    public void createChimeUser(ChimeUserInfoVo chimeUserInfoVo){
        mongoTemplate.save(chimeUserInfoVo,ChimeUserInfoVo.class.getSimpleName());
    }

    public void updateChimeUser(ChimeUserInfoVo chimeUserInfoVo) {
        UpdateResult result = mongoTemplate.updateFirst(
                Query.query(Criteria.where("userId").is(chimeUserInfoVo.getUserId())),
                Update.fromDocument(Document.parse(JsonUtils.toJson(chimeUserInfoVo))),
                ChimeUserInfoVo.class.getSimpleName()
        );
        log.info("updateChimeUser result:{}",result.toString());
    }

    public void createUserTagMapping(List<ChimeUserTagsMappingVo> chimeUserTagsMappingVoList){
        mongoTemplate.insert(chimeUserTagsMappingVoList,ChimeUserTagsMappingVo.class.getSimpleName());
    }

    public boolean updateUserTagMapping(String userId,List<ChimeUserTagsMappingVo> chimeUserTagsMappingVoList){

        Query query = Query.query(Criteria.where("userId").is(userId));
        //  根据条件删除（可删除多条）
        mongoTemplate.remove(query,ChimeUserTagsMappingVo.class.getSimpleName());
        Collection rsList = mongoTemplate.insert(chimeUserTagsMappingVoList,ChimeUserTagsMappingVo.class.getSimpleName());
        return rsList.size()>0;
    }

    /**
     * 根据订单id 获取 订单vo 详情
     *
     * @param orderId
     * @return
     */
    public KylinOrderTicketVo getOrderTicketVo(String orderId) {
        Object obj = redisUtil.get(KylinRedisConst.ORDER + orderId);
        if (obj!=null) {
            return (KylinOrderTicketVo) obj;
        } else {
            KylinOrderTicketVo ticketData = mongoTemplate.findOne(Query.query(Criteria.where("orderTicketsId").is(orderId)), KylinOrderTicketVo.class, KylinOrderTicketVo.class.getSimpleName());
            List<KylinOrderTicketEntitiesVo> kylinOrderTicketEntitiesVoList = mongoTemplate.find(Query.query(Criteria.where("orderId").is(orderId)), KylinOrderTicketEntitiesVo.class, KylinOrderTicketEntitiesVo.class.getSimpleName());
            ticketData.setEntitiesVoList(kylinOrderTicketEntitiesVoList);
            redisUtil.set(KylinRedisConst.ORDER + orderId, ticketData);
            return ticketData;
        }
    }

    /**
     * 根据演出id 获取 演出vo 详情
     *
     * @param performanceId
     * @return
     */
    public KylinPerformanceVo getPerformanceVo(String performanceId) {
        Object obj = redisUtil.get(KylinRedisConst.PERFORMANCES + performanceId);
        if (obj!=null) {
            return (KylinPerformanceVo)obj;
        } else {
            KylinPerformanceVo performanceData = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId)), KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
            redisUtil.set(KylinRedisConst.PERFORMANCES + performanceId, performanceData);
            return performanceData;
        }
    }
}
