package com.liquidnet.service.sweet.controller;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualAppletDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistList2Dto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.entity.SweetManualNotify;
import com.liquidnet.service.sweet.entity.SweetRichtext;
import com.liquidnet.service.sweet.entity.SweetStage;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "小程序")
@RestController
@RequestMapping("/sweet-applet")
public class SweetAppletController {

    @Autowired
    private RedisDataUtils redisDataUtils;

    @GetMapping("timeSelect")
    @ApiOperation("场次选择")
    public ResponseDto<List<SweetManualAppletDto>> timeSelect() {
        return ResponseDto.success(redisDataUtils.getPushList());
    }

    @GetMapping("details")
    @ApiOperation("详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
    })
    public ResponseDto<SweetManualAppletDto> details(@RequestParam(defaultValue = "1") String manualId) {
        return ResponseDto.success(redisDataUtils.getAppletPerformance(manualId));
    }

    @GetMapping("notify")
    @ApiOperation("通知")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
    })
    public ResponseDto<List<SweetManualNotify>> notify(@RequestParam(defaultValue = "1") String manualId) {
        return ResponseDto.success(redisDataUtils.getNotifyRedisData(manualId));
    }

    @GetMapping("tags")
    @ApiOperation("标签")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
    })
    public ResponseDto<List<String>> tag(@RequestParam(defaultValue = "1") String manualId) {
        return ResponseDto.success(redisDataUtils.getTagRedisData(manualId));
    }

    @GetMapping("timeList")
    @ApiOperation("时间表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "dateTime", value = "时间 全部传 \"\"", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "stage", value = "舞台 全部传 \"\"", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isSign", value = "是否签名(1是0否)", required = true),
    })
    public ResponseDto<SweetManualArtistList2Dto> timeList(@RequestParam(defaultValue = "1") String manualId,
                                                           @RequestParam(defaultValue = "2021-12-01") String dateTime,
                                                           @RequestParam(defaultValue = "测试舞台") String stage,
                                                           @RequestParam(defaultValue = "isSign") Integer isSign) {
        SweetManualArtistList2Dto data = redisDataUtils.getTimeList(manualId);
        List<SweetManualArtistListDto> artistData = data.getData();
        List<SweetManualArtistListDto> returnArtist = data.getData();
        for (SweetManualArtistListDto item : artistData) {

            boolean isSave = false;

            if (isSign == 1) {
                if (item.getSignatureStart() != null) {
                    //保留
                    isSave = true;
                }
            }

            if (!dateTime.isEmpty()) {
                if (item.getPerformanceStart().contains(dateTime)) {
                    //保留
                    isSave = true;
                }
            }

            if (!stage.isEmpty()) {
                if (item.getTitle().equalsIgnoreCase(stage)) {
                    //保留
                    isSave = true;
                }
            }

            if (isSave) {
                returnArtist.add(item);
            }

        }
        data.setData(returnArtist);
        return ResponseDto.success(data);
    }

    @GetMapping("richText")
    @ApiOperation("富文本")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "type", value = "类型 (1签售时间 2现场地图 3官方大巴 4公共交通 5自驾导航坐标 6官方支持 7观众须知 8防疫指南 9观演攻略)", required = true),
    })
    public ResponseDto<SweetRichtext> richText(@RequestParam(defaultValue = "1") String manualId,
                                               @RequestParam(defaultValue = "1") String type) {
        return ResponseDto.success(redisDataUtils.getRichTextRedisData(manualId, type));
    }

    @GetMapping("artistDetails")
    @ApiOperation("艺人详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "type", value = "类型 (1签售时间 2现场地图 3官方大巴 4公共交通 5自驾导航坐标 6官方支持 7观众须知 8防疫指南 9观演攻略)", required = true),
    })
    public ResponseDto<SweetRichtext> artistDetails(@RequestParam(defaultValue = "1") String manualId,
                                                    @RequestParam(defaultValue = "1") String type) {
        return ResponseDto.success(redisDataUtils.getRichTextRedisData(manualId, type));
    }

}
