package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@EqualsAndHashCode
public class GoblinMixAppDetailsVo implements Serializable, Cloneable {
    @ApiModelProperty(position = 0, value = "活动id")
    private String mixId;
    @ApiModelProperty(position = 1, value = "活动名称")
    private String name;
    @ApiModelProperty(position = 2, value = "开始时间")
    private String timeStart;
    @ApiModelProperty(position = 3, value = "结束时间")
    private String timeEnd;
    @ApiModelProperty(position = 5, value = "组合名称")
    private String sellName;
    @ApiModelProperty(position = 9, value = "商品简介/购买须知")
    private String intro;
    @ApiModelProperty(position = 10, value = "封面图片地址")
    private String coverPic;
    @ApiModelProperty(position = 11, value = "商品视频地址/数字昌平视频地址")
    private String video;
    @ApiModelProperty(position = 12, value = "商品详情/藏品详情")
    private String details;
    @ApiModelProperty(position = 13, value = "展示文件类型[1-图片|2-视频]")
    private Integer watchType;
    @ApiModelProperty(position = 14, value = "详情图片地址")
    private String detailUrl;
    @ApiModelProperty(position = 17, value = "限购数量[0-无限]")
    private Integer limit;
    @ApiModelProperty(position = 18, value = "白名单类型[0-会员|1-指定用户|2-全部用户]")
    private Integer whiteType;
/*    @ApiModelProperty(position = 20, value = "配置详情")
    private List<GoblinMixDetailsItemVo> item;*/
    @ApiModelProperty(position = 22, value = "状态[6-活动中|7-停用|8-售罄|9-等待开始|10-活动结束]")
    private Integer status;
    @ApiModelProperty(position = 24, value = "IOS支付方式[0-第三方支付|1-苹果支付]")
    private Integer payType;
    @ApiModelProperty(position = 25, value = "店铺名称]")
    private String storeName;
    @ApiModelProperty(position = 23, value = "销售价格")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 23, value = "原价")
    private BigDecimal price;

    private static final GoblinMixAppDetailsVo obj = new GoblinMixAppDetailsVo();

    public static GoblinMixAppDetailsVo getNew() {
        try {
            return (GoblinMixAppDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMixAppDetailsVo();
        }
    }

  /*  public GoblinMixAppDetailsVo copy(GoblinMixDetailsVo source,String storeName) {
        if (null == source) return this;
        this.setMixId(source.getMixId());
        this.setName(source.getName());
        this.setTimeStart(source.getTimeStart());
        this.setTimeEnd(source.getTimeEnd());
        this.setSellName(source.getSellName());
        this.setIntro(source.getIntro());
        this.setCoverPic(source.getCoverPic());
        this.setVideo(source.getVideo());
        this.setDetails(source.getDetails());
        this.setWatchType(source.getWatchType());
        this.setDetailUrl(source.getDetailUrl());
        this.setLimit(source.getLimit());
        this.setWhiteType(source.getWhiteType());
        this.setItem(source.getItem());
        this.setPayType(source.getPayType());
        this.setStoreName(storeName);
        this.setPrice(source.getPrice());
        this.setSellPrice(source.getSellPrice());
        return this;
    }*/
}
