package com.liquidnet.service.merchant.controller;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.PerformancePartnerListDao;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerListParam;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.param.PerformanceStep1Param;
import com.liquidnet.service.kylin.dto.param.PerformanceStep2Param;
import com.liquidnet.service.kylin.dto.vo.PerformanceOrderStatisticalVo;
import com.liquidnet.service.kylin.service.partner.IKylinPerformancesPartnerService;
import com.liquidnet.service.merchant.util.MongoMerchantUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "第三方-演出", position = 1001)
@RestController
@RequestMapping("partner/performance")
@Validated
public class KylinPerformancePartnerController {

    @Autowired
    private IKylinPerformancesPartnerService performancesPartnerService;
    @Autowired
    MongoMerchantUtils mongoMerchantUtils;

    @PostMapping(value = "list")
    @ApiOperation(value = "演出列表", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<PerformancePartnerListDao>> getList(@RequestBody @Valid PerformancePartnerListParam performancePartnerListParam) {
        return performancesPartnerService.getList(performancePartnerListParam);
    }

    @PostMapping(value = "copy")
    @ApiOperation(value = "复制演出", position = 6)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Map<String, String>> copyPerformance(@RequestParam("performancesId") @NotNull(message = "演出ID不能为空") String performancesId) {
        String result = performancesPartnerService.copyPerformance(performancesId);
        if (null == result) {
            return ResponseDto.failure("复制失败");
        } else if ("无权限".equals(result)) {
            return ResponseDto.failure("无权限");
        } else {
            Map<String, String> map = new HashMap<>();
            map.put("performancesId", result);
            return ResponseDto.success(map);
        }
    }


    @GetMapping(value = "step1")
    @ApiOperation(value = "获取演出第一步数据", position = 3)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PerformancePartnerVo> getStep1(@RequestParam("performancesId") @NotNull(message = "演出ID不能为空") String performancesId) {
        return performancesPartnerService.getStep1(performancesId);
    }

    @PostMapping(value = "step1")
    @ApiOperation(value = "操作演出第一步", position = 2)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Map<String, String>> Step1(@RequestBody @Valid PerformanceStep1Param performanceStep1Param) {
        String result = performancesPartnerService.step1(performanceStep1Param);
        if (result.isEmpty()) {
            return ResponseDto.failure("操作失败");
        } else if (result.equals("不可修改")) {
            return ResponseDto.failure(result);
        } else if ("无权限".equals(result)) {
            return ResponseDto.failure("无权限");
        } else {
            Map<String, String> map = new HashMap<>();
            map.put("performancesId", result);
            return ResponseDto.success(map);
        }
    }


    @PostMapping(value = "step2")
    @ApiOperation(value = "操作演出第二步", position = 4)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> step2(@RequestBody @Valid PerformanceStep2Param performanceStep2Param) {
        return performancesPartnerService.step2(performanceStep2Param);
    }

    @GetMapping(value = "step2")
    @ApiOperation(value = "获取演出第二步数据", position = 5)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PerformanceStep2Param> getStep2(@RequestParam("performancesId") @NotNull(message = "演出ID不能为空") String performancesId) {
        return performancesPartnerService.getStep2(performancesId);
    }

    @PostMapping(value = "online")
    @ApiOperation(value = "演出上线", position = 7)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> onLinePerformance(@RequestParam("performancesId") @NotNull(message = "演出ID不能为空") String performancesId) {
        return performancesPartnerService.onLinePerformance(performancesId);
    }

    @PostMapping(value = "outline")
    @ApiOperation(value = "演出下线", position = 8)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> outLinePerformance(@RequestParam("performancesId") @NotNull(message = "演出ID不能为空") String performancesId) {
        return performancesPartnerService.outLinePerformance(performancesId);
    }

    @PostMapping(value = "withdraw")
    @ApiOperation(value = "演出撤回", position = 9)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> withdraw(@RequestParam("performancesId") @NotNull(message = "演出ID不能为空") String performancesId) {
        return performancesPartnerService.withdraw(performancesId);
    }
}
