package com.liquidnet.service.goblin.controller.manage;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtThumbVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreOrderListVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreOrderService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

@ApiSupport(order = 149002)
@Api(tags = "店铺-订单")
@Slf4j
@Validated
@RestController
@RequestMapping("store/order")
public class GoblinStoreOrderController {
    @Autowired
    IGoblinStoreOrderService goblinStoreOrderService;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;

    @ApiOperation(value = "订单列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "orderCode", value = "订单编号"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "type", value = "订单类型[0-全部|1-普通订单]"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "cst", value = "下单起始时间"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "cet", value = "下单终止时间"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "expressContacts", value = "收货人姓名"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "phone", value = "手机号"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "status", value = "订单状态[0-代付款|2-待发货|3-已发货|4-已完成]"),
    })
    @GetMapping(value = "list")
    public ResponseDto<PageInfo<GoblinStoreOrderListVo>> orderList(@RequestParam(value = "page", required = true) @Valid Integer page,
                                                                   @RequestParam(value = "orderCode", required = false) String orderCode,
                                                                   @RequestParam(value = "type", required = false) Integer type,
                                                                   @RequestParam(value = "cst", required = false) String cst,
                                                                   @RequestParam(value = "cet", required = false) String cet,
                                                                   @RequestParam(value = "expressContacts", required = false) String expressContacts,
                                                                   @RequestParam(value = "phone", required = false) String phone,
                                                                   @RequestParam(value = "status", required = false) Integer status) {

        return goblinStoreOrderService.orderList(page, orderCode, type, cst, cet, expressContacts, phone, status);
    }

    @ApiOperation(value = "订单详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "orderId", value = "订单id"),
    })
    @GetMapping(value = "details")
    public ResponseDto<GoblinStoreOrderListVo> orderList(@RequestParam(value = "orderId", required = true) @Valid String orderId) {
        return goblinStoreOrderService.orderDetails(orderId);
    }
}
