package com.liquidnet.service.goblin.util;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.dto.vo.MaiZhiAllVo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Slf4j
@Component
public class ThirdMaiZhiUtils {
    private static final RestTemplate restTemplate = new RestTemplate();

    public AuthResponse login(String appid, String appSecret, String auth) {
        try {
            String url = "https://www.mz-cx.com/home/openapi/auth";

            // 创建请求头并设置 Authorization
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Authorization", auth);

            // 创建 AuthParam 参数
            AuthParam param = new AuthParam();
            param.setAppid(appid);
            param.setAppSecret(appSecret);

            // 创建 HttpEntity 封装请求体和请求头
            HttpEntity<AuthParam> request = new HttpEntity<>(param, headers);

            // 发起 POST 请求
            ResponseEntity<String> response = restTemplate.exchange(url, HttpMethod.POST, request, String.class);

            // 处理响应
            if (response.getStatusCode() == HttpStatus.OK) {
                return JsonUtils.fromJson(response.getBody(), AuthResponse.class);
            } else {
                throw new Exception("Login API failed with status: " + response.getStatusCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CheckIdcardResponse checkIdcard(String accessToken, String idcard, String aname) {
        try {
            String url = "https://www.mz-cx.com/home/openapi/check_idcard";

            // 创建请求头并设置 Authorization
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("access-token", accessToken);

            // 创建 AuthParam 参数
            IdCardParam param = new IdCardParam();
            param.setName(aname);
            param.setIdcard(idcard);

            // 创建 HttpEntity 封装请求体和请求头
            HttpEntity<IdCardParam> request = new HttpEntity<>(param, headers);

            // 发起 POST 请求
            ResponseEntity<String> response = restTemplate.exchange(url, HttpMethod.POST, request, String.class);

            // 处理响应
            if (response.getStatusCode() == HttpStatus.OK) {
                return JsonUtils.fromJson(response.getBody(), CheckIdcardResponse.class);
            } else {
                throw new Exception("checkIdcard API failed with status: " + response.getStatusCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public OrderResponse addOrder(String accessToken, OrderParam param) {
        try {
            String url = "https://www.mz-cx.com/home/openapi/ordercomplete";

            // 创建请求头并设置 Authorization
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("access-token", accessToken);

            // 创建 HttpEntity 封装请求体和请求头
            HttpEntity<OrderParam> request = new HttpEntity<>(param, headers);

            // 发起 POST 请求
            ResponseEntity<String> response = restTemplate.exchange(url, HttpMethod.POST, request, String.class);

            // 处理响应
            if (response.getStatusCode() == HttpStatus.OK) {
                return JsonUtils.fromJson(response.getBody(), OrderResponse.class);
            } else {
                throw new Exception("addOrder API failed with status: " + response.getStatusCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public OrderInfoResponse getOrder(String accessToken, OrderInfoParam param) {
        try {
            String url = "https://www.mz-cx.com/home/openapi/orderinquiry";

            // 创建请求头并设置 Authorization
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("access-token", accessToken);

            // 创建 HttpEntity 封装请求体和请求头
            HttpEntity<OrderInfoParam> request = new HttpEntity<>(param, headers);

            // 发起 POST 请求
            ResponseEntity<String> response = restTemplate.exchange(url, HttpMethod.POST, request, String.class);

            // 处理响应
            if (response.getStatusCode() == HttpStatus.OK) {
                return JsonUtils.fromJson(response.getBody(), OrderInfoResponse.class);
            } else {
                throw new Exception("getOrder API failed with status: " + response.getStatusCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GenerateDeviceCodeResponse generateDeviceCode(String accessToken, String outno) {
        try {
            String url = String.format("https://www.mz-cx.com/home/openapi/get_ma?outno=%s", outno);

            // 创建请求头并设置 Authorization
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("access-token", accessToken);

            HttpEntity<Void> request = new HttpEntity<>(headers);
            ResponseEntity<String> response = restTemplate.exchange(url, HttpMethod.GET, request, String.class);

            // 处理响应
            if (response.getStatusCode() == HttpStatus.OK) {
                return JsonUtils.fromJson(response.getBody(), GenerateDeviceCodeResponse.class);
            } else {
                throw new Exception("generateDeviceCode API failed with status: " + response.getStatusCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DeviceNumberResponse getDeviceNumber(String accessToken, Integer operationNo, String starttime, String endtime) {
        try {
            String url = "https://www.mz-cx.com/home/openapi/get_ordercardno";

            // 创建请求头并设置 Authorization
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("access-token", accessToken);

            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl(url)
                    .queryParam("operationNo", operationNo)
                    .queryParam("starttime", starttime)
                    .queryParam("endtime", endtime);

            HttpEntity<Void> request = new HttpEntity<>(headers);
            ResponseEntity<String> response = restTemplate.exchange(builder.toUriString(), HttpMethod.GET, request, String.class);

            // 处理响应
            if (response.getStatusCode() == HttpStatus.OK) {
                return JsonUtils.fromJson(response.getBody(), DeviceNumberResponse.class);
            } else {
                throw new Exception("getDeviceNumber API failed with status: " + response.getStatusCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DeviceBalanceResponse getDeviceBalance(String accessToken, String cardno) {
        try {
            String url = String.format("https://www.mz-cx.com/home/openapi/get_cardmoney?cardno=%s", cardno);

            // 创建请求头并设置 Authorization
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("access-token", accessToken);

            HttpEntity<Void> request = new HttpEntity<>(headers);
            ResponseEntity<String> response = restTemplate.exchange(url, HttpMethod.GET, request, String.class);

            // 处理响应
            if (response.getStatusCode() == HttpStatus.OK) {
                return JsonUtils.fromJson(response.getBody(), DeviceBalanceResponse.class);
            } else {
                throw new Exception("getDeviceBalance API failed with status: " + response.getStatusCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DeviceRecordResponse getDeviceRecord(String accessToken, String cardno, Integer page) {
        try {
            String url = String.format("https://www.mz-cx.com/home/openapi/get_cardlist?cardno=%s&page=%s", cardno, page);

            // 创建请求头并设置 Authorization
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("access-token", accessToken);

            HttpEntity<Void> request = new HttpEntity<>(headers);
            ResponseEntity<String> response = restTemplate.exchange(url, HttpMethod.GET, request, String.class);

            // 处理响应
            if (response.getStatusCode() == HttpStatus.OK) {
                return JsonUtils.fromJson(response.getBody(), DeviceRecordResponse.class);
            } else {
                throw new Exception("getDeviceRecord API failed with status: " + response.getStatusCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ChangeDeviceStatusResponse changeDeviceStatus(ChangeDeviceStatusParam param, String token) throws Exception {
        String url = "https://www.mz-cx.com/home/openapi/upd_cardtype";
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + token);

        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl(url)
                .queryParam("cardno", param.getCardno())
                .queryParam("type", param.getType());

        HttpEntity<Void> request = new HttpEntity<>(headers);
        ResponseEntity<ChangeDeviceStatusResponse> response = restTemplate.exchange(builder.toUriString(), HttpMethod.GET, request, ChangeDeviceStatusResponse.class);

        if (response.getStatusCode() == HttpStatus.OK) {
            return response.getBody();
        } else {
            throw new Exception("Device status change failed with status: " + response.getStatusCode());
        }
    }

}
