package com.liquidnet.service.kylin.controller;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.adam.dto.vo.admin.AdminUpushVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinPerformanceSubscribeUpushVo;
import com.liquidnet.service.kylin.service.impl.KylinUpushServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.LinkedList;

/**
 * <p>
 * 友盟推送 系统消息
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-15
 */
@Api(tags = "basicServices")
@RestController
@RequestMapping("basicServices/upush")
public class KylinUpushController {

    @Autowired
    private KylinUpushServiceImpl upushServiceImpl;

    @GetMapping("system")
    @ApiOperation("系统消息列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "每页数量"),
    })
    public ResponseDto<PageInfo<AdminUpushVo>> lists(
            HttpServletRequest request,
            @RequestParam(defaultValue = "1") Integer page,
            @RequestParam(defaultValue = "10") Integer size
    ) {
        PageInfo<AdminUpushVo> result = upushServiceImpl.lists(request, page, size);

        return ResponseDto.success(result);
    }

    @GetMapping("unread")
    @ApiOperation("用户未读数量")
    public ResponseDto<Integer> unread(HttpServletRequest request) {
        Integer num = upushServiceImpl.unread(request);
        return ResponseDto.success(num);
    }


    @GetMapping("billingReminderList")
    @ApiOperation("开票提醒消息列表")
    public ResponseDto<LinkedList<KylinPerformanceSubscribeUpushVo>> billingReminderList() {
        return ResponseDto.success(upushServiceImpl.billingReminderList());
    }

    @GetMapping("billingReminderUnread")
    @ApiOperation("开票提醒用户未读数量")
    public ResponseDto<Integer> billingReminderUnread() {
        return ResponseDto.success(upushServiceImpl.billingReminderUnread());
    }
}
