package com.liquidnet.service.galaxy;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.constant.ZxlErrorEnum;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.common.third.zxlnft.dto.*;
import com.liquidnet.common.third.zxlnft.dto.wallet.*;
import com.liquidnet.common.third.zxlnft.exception.ZxlNftException;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.BASE64Util;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.io.UnsupportedEncodingException;

import static com.liquidnet.service.galaxy.TestZxlnftSdkUtil.*;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestZxlnftService
 * @Package com.liquidnet.service.zxlnft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/3 16:55
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestZxlnftService {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private ZxlnftConfig zxlnftConfig;
    /**
     * 1、调用下发查询用户信息验证码接口
     * 发送查询验证码
     */
    @Test
    public void platformRegister_1(){
        String shenzongIdCard = "110102196904242477";

//        1.1.2调用下发查询用户信息验证码接口
        Nft011UserQueryVerifyCodeReqDto nft011UserQueryVerifyCodeReqDto = Nft011UserQueryVerifyCodeReqDto.getNew();
        //查询用户信息 发送手机验证码
        nft011UserQueryVerifyCodeReqDto.setType(Integer.valueOf(ZxlnftEnum.RegisterTypeEnum.COMPANY.getCode()));
        nft011UserQueryVerifyCodeReqDto.setCardNo(shenzongIdCard);
        nft011UserQueryVerifyCodeReqDto.setScene(Integer.valueOf(ZxlnftEnum.UseSceneEnum.QUERY.getCode()));
        ZxlnftResponseDto<Nft011UserQueryVerifyCodeRespDto> resp = zxlnftSdkUtil.nft011UserQueryVerifyCode(nft011UserQueryVerifyCodeReqDto);

    }

    /**
     * 2、调用查询用户信息接口
     * 获取用户唯一标识码
     */
    @Test
    public void platformRegister_2(){
        String shenzongIdCard = "110102196904242477";
//        1.1.3调用查询用户信息接口
        //查询企业 沈总
        Nft012UserQueryReqDto nft012UserQueryReqDto = Nft012UserQueryReqDto.getNew();
        nft012UserQueryReqDto.setType(Integer.valueOf(ZxlnftEnum.RegisterTypeEnum.COMPANY.getCode()));
        nft012UserQueryReqDto.setCardNo(shenzongIdCard);
        nft012UserQueryReqDto.setVerifyCode("153428");
        ZxlnftResponseDto<Nft012UserQueryRespDto> nft012UserQueryResp = zxlnftSdkUtil.nft012UserQuery(nft012UserQueryReqDto);
        if(nft012UserQueryResp.isSuccess()){
            Nft012UserQueryRespDto nft012UserQueryRespDto = nft012UserQueryResp.getData();
            log.info("userIdentification:{}",nft012UserQueryRespDto.getUserIdentification());
        }

    }

    /**
     * 3、调用下发用户信息查询验证码接口
     * 发送邮箱验证码
     */
    @Test
    public void platformRegister_3(){
        String shenzongIdCard = "110102196904242477";

//        1.1.4调用下发用户信息查询验证码接口
        Nft011UserQueryVerifyCodeReqDto reqBindDto = Nft011UserQueryVerifyCodeReqDto.getNew();
        //查询用户信息 发送邮箱验证码
        reqBindDto.setType(Integer.valueOf(ZxlnftEnum.RegisterTypeEnum.COMPANY.getCode()));
        reqBindDto.setCardNo(shenzongIdCard);
        reqBindDto.setScene(Integer.valueOf(ZxlnftEnum.UseSceneEnum.BINDING.getCode()));
        ZxlnftResponseDto<Nft011UserQueryVerifyCodeRespDto> nft011UserQueryVerifyCode = zxlnftSdkUtil.nft011UserQueryVerifyCode(reqBindDto);

    }

    /**
     * 4、生成平台助记词和公钥、私钥
     * （牢记助记词、公钥和私钥）
     */
    @Test
    public void platformRegister_4(){
        String mnemonic = "stuff name goat health siren dumb gorilla antique board tenant buffalo present"; //安家宾
//        String mnemonic = "economy cost balance weapon flight also nut biology very sun slight about"; //周焕
        Long index = 0L;
        String userPubKey = null;
        String userPriKey = null;

        try{
            //生成助记词
            CreateMnemonicReq req = CreateMnemonicReq.getNew();
            CreateMnemonicResp createMnemonicResp = zxlWalletSdkUtil.createMnemonic(req);
            mnemonic = createMnemonicResp.getMnemonic();
        }catch(Exception e){
            throw new ZxlNftException(ZxlErrorEnum.FAILURE.getCode(),"生成助记词失败！");
        }

        log.info("平台助记词:{}",mnemonic);
        /**
         * todo 把助记词进行redis存储  key=userID  mnemonic/index/userIdentification/address
         */

        if(StringUtil.isNotEmpty(mnemonic)){
            //生成公私钥
            DeriveKeyPairReq deriveKeyPairReq = DeriveKeyPairReq.getNew();
            deriveKeyPairReq.setMnemonic(mnemonic);
//        deriveKeyPairReq.setMnemonic(createMnemonicResp.getMnemonic());
            deriveKeyPairReq.setIndex(index);
            try{
                DeriveKeyPairResp deriveKeyPairResp = zxlWalletSdkUtil.deriveKeyPair(deriveKeyPairReq);
                if(!deriveKeyPairResp.getErr().equals("")) throw new Exception("生成公私钥失败！");
                userPubKey = BASE64Util.encoded(deriveKeyPairResp.getPubKey());
                userPriKey = BASE64Util.encoded(deriveKeyPairResp.getPriKey());
            }catch(Exception e){
                throw new ZxlNftException(ZxlErrorEnum.FAILURE.getCode(),e.getMessage());
            }
        }
        log.info("平台公钥：{}",userPubKey);
        log.info("平台私钥：{}",userPriKey);

    }

    /**
     * 5、调用NFT平台自身地址绑定接口
     */
    @Test
    public void platformRegister_5(){
        String userIdentification = "5ad54233459887b739d50e6aa026ec26fe43ccf24bc3da5865bba22295c8f180";

//        1.1.5调用NFT平台自身地址绑定接口
        Nft015IdentityBindPlatformSelfReqDto nft015IdentityBindPlatformSelfReqDto = Nft015IdentityBindPlatformSelfReqDto.getNew();
        //从步骤4获取的公钥
        nft015IdentityBindPlatformSelfReqDto.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        //从步骤2获取的用户唯一标识
        nft015IdentityBindPlatformSelfReqDto.setUserIdentification(userIdentification);
        //从步骤3获取的邮箱验证码
        nft015IdentityBindPlatformSelfReqDto.setVerifyCode("630216");
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),nft015IdentityBindPlatformSelfReqDto.getUserIdentification());
        nft015IdentityBindPlatformSelfReqDto.setSignData(signature);
        ZxlnftResponseDto<Nft015IdentityBindPlatformSelfRespDto> resp = zxlnftSdkUtil.nft015IdentityBindPlatformSelf(nft015IdentityBindPlatformSelfReqDto);
        System.out.println(resp.toJson());

//        1.1.6调用绑定状态批量查询接口


    }


    /**
     * 2、自然人用户通过NFT平台注册绑定
     */
    @Test
    public void personRegisterBind(){
        String userId = "310508344264376327445470";
        String userName = "安家宾";
        String mobile = "13811314082";
        String idCardType = ZxlnftEnum.CardTypeEnum.ID_CARD.getCode();
        String idCard = "142323198302062216";

//        String userName = "周焕";
//        String mobile = "18548596019";
//        String idCardType = ZxlnftEnum.CardTypeEnum.ID_CARD.getCode();
//        String idCard = "150422199805206019";

        String mnemonic = "stuff name goat health siren dumb gorilla antique board tenant buffalo present"; //安家宾
//        String mnemonic = "economy cost balance weapon flight also nut biology very sun slight about"; //周焕
        Long index = 0L;
        String userIdentification = null;
        String address = null;
        String userPubKey = null;
        String userPriKey = null;

        try{
            //生成助记词
            CreateMnemonicReq req = CreateMnemonicReq.getNew();
            CreateMnemonicResp createMnemonicResp = zxlWalletSdkUtil.createMnemonic(req);
            mnemonic = createMnemonicResp.getMnemonic();
        }catch(Exception e){
            throw new ZxlNftException(ZxlErrorEnum.FAILURE.getCode(),"生成助记词失败！");
        }

        /**
         * todo 把助记词进行redis存储  key=userID  mnemonic/index/userIdentification/address
         */

        if(StringUtil.isNotEmpty(mnemonic)){
            //生成公私钥
            DeriveKeyPairReq deriveKeyPairReq = DeriveKeyPairReq.getNew();
            deriveKeyPairReq.setMnemonic(mnemonic);
//        deriveKeyPairReq.setMnemonic(createMnemonicResp.getMnemonic());
            deriveKeyPairReq.setIndex(index);
            try{
                DeriveKeyPairResp deriveKeyPairResp = zxlWalletSdkUtil.deriveKeyPair(deriveKeyPairReq);
                if(!deriveKeyPairResp.getErr().equals("")) throw new Exception("生成公私钥失败！");
                userPubKey = BASE64Util.encoded(deriveKeyPairResp.getPubKey());
                userPriKey = BASE64Util.encoded(deriveKeyPairResp.getPriKey());
            }catch(Exception e){
                throw new ZxlNftException(ZxlErrorEnum.FAILURE.getCode(),e.getMessage());
            }
        }

        //1.2.1调用自然人注册实名(使用NFT平台签名)接口
        Nft003RegisterPersonPlatformReqDto nft003ReqDto = Nft003RegisterPersonPlatformReqDto.getNew();
        nft003ReqDto.setPersonName(userName);
//        reqDto.setEmail("");
        nft003ReqDto.setMobile(mobile);
        nft003ReqDto.setIdCard(idCard);

        nft003ReqDto.setCardType(Integer.valueOf(idCardType));
        ZxlnftResponseDto<Nft003RegisterPersonPlatformRespDto> nft003Resp = zxlnftSdkUtil.nft003RegisterPersonPlatform(nft003ReqDto);

        if(nft003Resp.isSuccess()){
            userIdentification = nft003Resp.getData().getUserIdentification();
        }

        //
        if(StringUtil.isNotEmpty(userPubKey)&&StringUtil.isNotEmpty(userPriKey)&&StringUtil.isNotEmpty(userIdentification)){
            //1.2.2调用授信平台NFT地址绑定接口
            Nft014IdentityBindSubmitByTrustedReqDto nft014ReqDto = Nft014IdentityBindSubmitByTrustedReqDto.getNew();

            try {
                nft014ReqDto.setUserPubKey(BASE64Util.decode(userPubKey));
                nft014ReqDto.setUserIdentification(nft003Resp.getData().getUserIdentification());

                String signature = zxlnftBiz.createSign(BASE64Util.decode(userPriKey),nft014ReqDto.getUserIdentification());
                nft014ReqDto.setUserSignData(signature);
            } catch (UnsupportedEncodingException e) {
                log.error("公私钥解密错误！");
            }

            ZxlnftResponseDto<Nft014IdentityBindSubmitByTrustedRespDto> nft014Resp = zxlnftSdkUtil.nft014IdentityBindSubmitByTrusted(nft014ReqDto);

            if(nft014Resp.isSuccess()){
                //1.2.3调用绑定状态批量查询
                Nft016IdentityBindQueryReqDto nft016ReqDto = Nft016IdentityBindQueryReqDto.getNew();
                nft016ReqDto.setAddressList(nft014Resp.getData().getAddress());
                ZxlnftResponseDto<Nft016IdentityBindQueryRespDto> nft016Resp = zxlnftSdkUtil.nft016IdentityBindQuery(nft016ReqDto);

                if(nft016Resp.isSuccess()){
                    log.info("返回结果：{}",nft016Resp.toJson());
                }
            }else{
                log.info("返回结果：{}",nft014Resp.toJson());
            }
        }
    }

    /**
     * 3、素材上传操作
     */
    @Test
    public void nftUpload(){
        String imageUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";
//        String seriesName = "NOW_ZXL_NFT_PIC_skuId001"; //系列名字 skuId
        String seriesName = "NOW_ZXL_NFT_PIC_skuId002"; //系列名字 skuId
//        String filePath = "/Users/anjiabin/Downloads/zxl_image_test_002.jpeg";
//        String filePath = "/Users/anjiabin/Downloads/zxl_image_series_test_001.jpeg";
        String filePath = "/Users/anjiabin/Downloads/zxl_image_test_001.jpg";
        String fileName = DateUtil.getNowTime(DateUtil.DATE_SMALL_STR)+"/"+ IDGenerator.getZxlNftImageCosCode() +".jpg";

        //完整全路径 https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/NOW_ZXL_NFT_PIC001_test_skuId001/2022-03-04/ZXLNFTIMAGE202203041707466694345291.jpg
        String fullFilePath = null; //需要保存,返回给调用者
        String seriesId = null;

//        1.4.1调用图片内容检测接口
        Nft008QueryImageModerationReqDto nft008ReqDto = Nft008QueryImageModerationReqDto.getNew();
        nft008ReqDto.setImageUrl(imageUrl);
        ZxlnftResponseDto<Nft008QueryImageModerationRespDto> nft008RespDto = zxlnftSdkUtil.nft008QueryImageModeration(nft008ReqDto);
        if(!nft008RespDto.getData().getSuggestion().equals(ZxlnftEnum.SuggestionEnum.PASS.getCode())){
           throw new ZxlNftException(ZxlErrorEnum.IMAGE_CHECK_ERROR.getCode(),ZxlErrorEnum.IMAGE_CHECK_ERROR.getMsg());
        }

//        1.4.2调用生成素材上传临时密钥接口
        Nft022UploadSecretReqDto nft022ReqDto = Nft022UploadSecretReqDto.getNew();
        nft022ReqDto.setSeriesName(seriesName);
        nft022ReqDto.setTimestamp(DateUtil.getNowSeconds().toString());
        nft022ReqDto.setUserPubKey(zxlnftConfig.getNftPlatformPubKey());

        //系列为空
        String userData = nft022ReqDto.getTimestamp();
        //系列不为空
        if(StringUtil.isNotEmpty(nft022ReqDto.getSeriesName())){
            userData = nft022ReqDto.getTimestamp() + "_" + nft022ReqDto.getSeriesName();
        }

        nft022ReqDto.setUserSignedData(zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),userData));

        ZxlnftResponseDto<Nft022UploadSecretRespDto> nft022RespDto = zxlnftSdkUtil.nft022UploadSecret(nft022ReqDto);

        if(!nft022RespDto.isSuccess()){
            throw new ZxlNftException(ZxlErrorEnum.UPLOAD_TEMP_SECRET.getCode(),ZxlErrorEnum.UPLOAD_TEMP_SECRET.getMsg());
        }
//        1.4.3调用sdk接口-上传cos接口
        if(nft022RespDto.isSuccess()){
            fullFilePath = nft022RespDto.getData().getUploadAddress().concat(fileName);
            UploadToCosReq req = UploadToCosReq.getNew();
            req.setCosPath(fullFilePath);
            req.setTempSecretId(nft022RespDto.getData().getTempSecretId());
            req.setTempSecretKey(nft022RespDto.getData().getTempSecretKey());
            req.setSessionToken(nft022RespDto.getData().getSessionToken());
            req.setFilePath(filePath);
            UploadToCosResp uploadToCosResp = zxlWalletSdkUtil.uploadToCos(req);
        }

        log.info("完整的素材访问fullFilePath url：{}",fullFilePath);

//        1.4.4调用查询素材地址接口 -- 非必需
//        Nft021UploadUrlReqDto nft021ReqDto = Nft021UploadUrlReqDto.getNew();
//        nft021ReqDto.setSeriesName(seriesName);
//        nft021ReqDto.setPlatformIdentification(zxlnftConfig.getPlatformIdentification());
//        //如果上传人就是平台管理员，以下需要注释掉，因为会导致返回的地址多了一级目录
////        nft021ReqDto.setUserIdentification(zxlnftConfig.getPlatformIdentification());
//        ZxlnftResponseDto<Nft021UploadUrlRespDto> resp = zxlnftSdkUtil.nft021UploadUrl(nft021ReqDto);

        /**
         * 进行系列声明
         */
        Nft030SeriesClaimReqDto reqDto = Nft030SeriesClaimReqDto.getNew();
        reqDto.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        reqDto.setSeriesName(seriesName);
        //无限制系列 设置为0
        reqDto.setTotalCount(0l);
        reqDto.setOperateId(IDGenerator.get32UUID());
        //系列封面
        reqDto.setCoverUrl("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg");
        reqDto.setDesc("系列描述信息不超过500字符");
        reqDto.setMaxPublishCount(0);
        reqDto.setSeriesBeginFromZero(false);
        ZxlnftResponseDto<Nft030SeriesClaimRespDto> nft30RespDto = zxlnftSdkUtil.nft030SeriesClaim(reqDto);

        //{"taskId":"49d1cccc-e62c-40bc-923c-bfac31325351_nft-series-claim_1"}
        if(nft30RespDto.isSuccess()){
            //系列声明结果查询
            Nft031SeriesClaimResultReqDto nft031ReqDto = Nft031SeriesClaimResultReqDto.getNew();
            //第零个系列 无限制系列
            nft031ReqDto.setTaskId(nft30RespDto.getData().getTaskId());

            int count  = 0;
            while(StringUtil.isEmpty(seriesId)){
                //休眠1秒钟，等待执行结果
                try {
                    Thread.sleep(1000l);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }

                count++;
                log.info("=======执行第{}次查询,taskId:{}",count,nft031ReqDto.getTaskId());
                ZxlnftResponseDto<Nft031SeriesClaimResultRespDto> nft031RespDtoTemp = zxlnftSdkUtil.nft031SeriesClaimResult(nft031ReqDto);
                if(nft031RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    seriesId = nft031RespDtoTemp.getData().getSeriesId();
                    break;
                }else if(nft031RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    log.info("任务执行失败！taskId:{}",nft031ReqDto.getTaskId());
                    break;
                }

                if(count==6){
                    log.info("=======查询共6次，跳出循环！taskId:{}",nft031ReqDto.getTaskId());
                    break;
                }
            }

            log.info("系列声明结果查询 seriesId :{}",seriesId);
        }
    }

    @Test
    public void SeriesClaimResultQuery(){
        String taskId = "49d1cccc-e62c-40bc-923c-bfac31325351_nft-series-claim_1";

        Nft031SeriesClaimResultReqDto reqDto = Nft031SeriesClaimResultReqDto.getNew();
        //第零个系列 无限制系列
        reqDto.setTaskId(taskId);
        ZxlnftResponseDto<Nft031SeriesClaimResultRespDto> resp = zxlnftSdkUtil.nft031SeriesClaimResult(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 4、发行NFT
     */
    @Test
    public void nftPublish(){
        String author = "正在现场创作者001";
        String name = "上海草莓音乐节2022";
        String url = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";
        String displayUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";

        //第二中图片
        url = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/NOW_ZXL_NFT_PIC_skuId002/ZXLNFTIMAGE202203141616443229613632.jpg";
        displayUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";


        String desc = "NFT描述信息";
        String flag = "文创";
        //发行个数
        Long publishCount = 1L;
        //开始索引
        Integer seriesBeginIndex = 8;
        Long sellCount = 1000L; //积分
        //无限制系列
//        String seriesId = "4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_8a827e181b695fb8d9b081d3855d2895ced1d003ee186622a005cec37ea77e59";
        //系列001
        String seriesId = "4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_ca49b5ebadd5f73ab057fe869bf897cbcc0f31e0b89db71cc3ec78bca2d16ed6";
        //系列002
        //String seriesId = "4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_31ff9f7d4c33c98518e095fec6cecdab8d337751602cf6e651eb7d131cff5b61";


        //
        Nft032SeriesReqDto nft032ReqDto = Nft032SeriesReqDto.getNew();
        nft032ReqDto.setSeriesId(seriesId);
        //第零个系列 无限制系列查询
//        nft032ReqDto.setSeriesId("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_8a827e181b695fb8d9b081d3855d2895ced1d003ee186622a005cec37ea77e59");
        //第一个系列
//        nft032ReqDto.setSeriesId("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_ca49b5ebadd5f73ab057fe869bf897cbcc0f31e0b89db71cc3ec78bca2d16ed6");
        //第二个系列
//        nft032ReqDto.setSeriesId("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_31ff9f7d4c33c98518e095fec6cecdab8d337751602cf6e651eb7d131cff5b61");
        ZxlnftResponseDto<Nft032SeriesRespDto> resp = zxlnftSdkUtil.nft032Series(nft032ReqDto);

        //该系列已经发行多少个nft
        Long crtCount = resp.getData().getSeriesInfo().getCrtCount();
        log.info("系列：{} 已发行 ：{}",seriesId,crtCount);

        //3.1.2调用NFT发行接口
        /**
         * 发行无限制系列
         */
        Nft034PublishReqDto nft034ReqDto = Nft034PublishReqDto.getNew();
        nft034ReqDto.setAuthor(author);
        nft034ReqDto.setName(name);
        nft034ReqDto.setUrl(url);
        nft034ReqDto.setDisplayUrl(displayUrl);
        nft034ReqDto.setDesc(desc);
        nft034ReqDto.setFlag(flag);
        nft034ReqDto.setPublishCount(publishCount);
        //无限制零系列
        nft034ReqDto.setSeriesId(seriesId);
        nft034ReqDto.setSeriesBeginIndex(seriesBeginIndex);
        nft034ReqDto.setSellStatus(Integer.parseInt(ZxlnftEnum.SellStatusEnum.CAN_SELL.getCode()));
        nft034ReqDto.setSellCount(sellCount);
        nft034ReqDto.setOperateId(IDGenerator.get32UUID());
        nft034ReqDto.setMetaData("");

        ZxlnftResponseDto<Nft034PublishRespDto> nft034RespDto = zxlnftSdkUtil.nft034Publish(nft034ReqDto);

        if(nft034RespDto.isSuccess()){
            //3.1.4查询 NFT发行结果
            Nft035PublishResultReqDto nft035ReqDto = Nft035PublishResultReqDto.getNew();
            nft035ReqDto.setTaskId(nft034RespDto.getData().getTaskId());
            //休眠1秒钟，等待执行结果
            try {
                Thread.sleep(1000l);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            long timeStart = System.currentTimeMillis();
            log.info("=======执行第{}次查询,taskId:{}",1,nft035ReqDto.getTaskId());
            ZxlnftResponseDto<Nft035PublishResultRespDto> nft035RespDto = zxlnftSdkUtil.nft035PublishResult(nft035ReqDto);

            if(nft035RespDto.isSuccess()){
                if(nft035RespDto.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    log.info("任务执行失败！taskId:{} taskMsg:{}",nft035ReqDto.getTaskId(),nft035RespDto.getData().getTaskMsg());
                    return;
                }

                int count  = 1;
                String nftIdBegin = nft035RespDto.getData().getNftIdBegin();

                if(nft035RespDto.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.PROCESSING.getCode())){
                    log.info(ZxlnftEnum.TaskStatusEnum.PROCESSING.getMessage());
                    while(StringUtil.isEmpty(nftIdBegin)){
                        //休眠1秒钟，等待执行结果
                        try {
                            Thread.sleep(1000l);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }

                        count++;
                        ZxlnftResponseDto<Nft035PublishResultRespDto> nft035RespDtoTemp = zxlnftSdkUtil.nft035PublishResult(nft035ReqDto);
                        log.info("=======执行第{}次查询,taskId:{}",count,nft035ReqDto.getTaskId());
                        if(nft035RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                            nftIdBegin = nft035RespDtoTemp.getData().getNftIdBegin();
                        }else if(nft035RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                            log.info("任务执行失败！taskId:{}",nft035ReqDto.getTaskId());
                            return;
                        }

                        if(count==6){
                            log.info("=======查询共6次，跳出循环！taskId:{}",nft035ReqDto.getTaskId());
                            break;
                        }
                    }
                }else if(nft035RespDto.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    log.info(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getMessage());
                }

                log.info("发行NFT后返回给前端nftID:{}",nftIdBegin);
                log.info("总共执行了{}次查询 总耗时:{} MS",count,(System.currentTimeMillis() - timeStart));

                if(StringUtil.isNotEmpty(nftIdBegin)){
                    //3.1.3调用NFT查询接口
                    Nft036InfoReqDto nft036ReqDto = Nft036InfoReqDto.getNew();
                    nft036ReqDto.setNftId(nftIdBegin);
                    ZxlnftResponseDto<Nft036InfoRespDto> nft036RespDto = zxlnftSdkUtil.nft036Info(nft036ReqDto);
                    log.info("调用NFT查询接口 : {}",nft036RespDto.toJson());
                }
            }
        }
    }

    /**
     * 5、购买NFT
     */
    @Test
    public void nftBuy(){
//        3.2.1调用积分申请接口
//        3.2.2调用购买NFT接口
        Nft043BuyReqDto nft043BuyReqDto = Nft043BuyReqDto.getNew();
//        reqDto.setNftId("7f73aca56caaf57a20f0afff59318528f0f09ffbf028fe882161d3ce599d2854_1");
//        nft043BuyReqDto.setNftId("08c152e5fa467d28b7add8e408fb3ecd1ed2ff209364adc1e394bde53929df8f_1");
        nft043BuyReqDto.setNftId("43c169ae33d2ca5390a49d2319c14223ed5e7447c4b40c0422ef81691ddfee89_4");
        nft043BuyReqDto.setApplyScore(1000);
        nft043BuyReqDto.setReceiverPubKey(zhouhuanPubKey1);
        nft043BuyReqDto.setPointReceiverAddr(zhouhuanAddress1);
        nft043BuyReqDto.setOfferCount(1000l);
        nft043BuyReqDto.setOperateId(IDGenerator.get32UUID());

        /**
         * 接收人的私钥签名，签名对象是(platformPubKey_receiverPubKey_pointReceiverAddr_applyScore_接口名_nftId_offerCount_operateId)
         * 接口名：buy_nft
         */
        String signMetaData = zxlnftConfig.getNftPlatformPubKey()
                .concat("_").concat(nft043BuyReqDto.getReceiverPubKey())
                .concat("_").concat(nft043BuyReqDto.getPointReceiverAddr())
                .concat("_").concat(nft043BuyReqDto.getApplyScore().toString())
                .concat("_").concat("buy_nft")
                .concat("_").concat(nft043BuyReqDto.getNftId())
                .concat("_").concat(nft043BuyReqDto.getOfferCount().toString())
                .concat("_").concat(nft043BuyReqDto.getOperateId());
        String signature = zxlnftBiz.createSign(zhouhuanPriKey1,signMetaData);
        nft043BuyReqDto.setSignature(signature);

        ZxlnftResponseDto<Nft043BuyRespDto> nft043RespDto = zxlnftSdkUtil.nft043Buy(nft043BuyReqDto);
        if(nft043RespDto.isSuccess()){
            //3.2.4查询NFT购买结果
            Nft044BuyResultReqDto nft044ReqDto = Nft044BuyResultReqDto.getNew();
            nft044ReqDto.setTaskId(nft043RespDto.getData().getTaskId());
            long timeStart = System.currentTimeMillis();
            ZxlnftResponseDto<Nft044BuyResultRespDto> nft044RespDto = zxlnftSdkUtil.nft044BuyResult(nft044ReqDto);
            if(nft044RespDto.isSuccess()){
                int count  = 1;
                String payTaskId = null;
                while(payTaskId == null){
                    try {
                        Thread.sleep(1000l);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    count++;
                    log.info("=======执行第{}次查询,taskId:{}",1,nft044ReqDto.getTaskId());
                    ZxlnftResponseDto<Nft044BuyResultRespDto> nft044RespDtoTemp = zxlnftSdkUtil.nft044BuyResult(nft044ReqDto);
                    if(nft044RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                        payTaskId = nft044RespDtoTemp.getData().getPayTaskId();
                    }else if(nft044RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                        log.info("任务执行失败！taskId:{}",nft044ReqDto.getTaskId());
                        return;
                    }

                    if(count==6){
                        log.info("=======查询共6次，跳出循环！taskId:{}",nft044ReqDto.getTaskId());
                        break;
                    }
                }
                log.info("总共执行了多少次查询：{} 总耗时:{}",count,System.currentTimeMillis() - timeStart);
                if(StringUtil.isNotEmpty(payTaskId)){
                    //3.2.5查询NFT购买支付结果
                    Nft045BuyPayResultReqDto nft045ReqDto = Nft045BuyPayResultReqDto.getNew();
                    nft045ReqDto.setTaskId(payTaskId);
                    ZxlnftResponseDto<Nft045BuyPayResultRespDto> nft045RespDto = zxlnftSdkUtil.nft045BuyPayResult(nft045ReqDto);
                }
            }
        }

    }

    /**
     * 6、查询NFT相关信息
     */
    @Test
    public void nftQuery(){

    }

}
