package com.liquidnet.service.galaxy.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.aop.annotation.ControllerLog;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.service.IGalaxyTradeQueryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyTradeQueryController
 * @Package com.liquidnet.service.galaxy.controller
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/7 16:12
 */
@Api(tags = "NFT交易查询相关")
@RestController
@RequestMapping("nftTradeQuery")
@Validated
@Slf4j
public class GalaxyTradeQueryController {
    @Resource(name = "galaxyTradeQueryService")
    private IGalaxyTradeQueryService galaxyTradeQueryService;

    @ControllerLog(description = "NFT信息查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT信息查询")
    @PostMapping(value = {"queryNftInfo"})
    public ResponseDto<GalaxyQueryNftInfoRespDto> queryNftInfo(@Valid @RequestBody GalaxyQueryNftInfoReqDto reqDto){
        return galaxyTradeQueryService.queryNftInfo(reqDto);
    }


    @ControllerLog(description = "单个NFT交易信息查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "单个NFT交易信息查询")
    @PostMapping(value = {"queryNftTradeList"})
    ResponseDto<GalaxyQueryNftTradeListRespDto> queryNftTradeList(@Valid @RequestBody GalaxyQueryNftTradeListReqDto reqDto){
        return galaxyTradeQueryService.queryNftTradeList(reqDto);
    }

    @ControllerLog(description = "系列查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "系列查询")
    @PostMapping(value = {"querySeriesInfo"})
    ResponseDto<GalaxyQuerySeriesInfoRespDto> querySeriesInfo(GalaxyQuerySeriesInfoReqDto reqDto){
        return galaxyTradeQueryService.querySeriesInfo(reqDto);
    }

    @ControllerLog(description = "用户系列NFT查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "用户系列NFT查询")
    @PostMapping(value = {"queryUserSeriesNftList"})
    ResponseDto<GalaxyQueryUserSeriesNftListRespDto> queryUserSeriesNftList(GalaxyQueryUserSeriesNftListReqDto reqDto){
        return galaxyTradeQueryService.queryUserSeriesNftList(reqDto);
    }

    @ControllerLog(description = "用户所有进出NFT信息查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "用户所有进出NFT信息查询")
    @PostMapping(value = {"queryUserTradeAllList"})
    ResponseDto<GalaxyQueryUserTradeAllListRespDto> queryUserTradeAllList(GalaxyQueryUserTradeAllListReqDto reqDto){
        return galaxyTradeQueryService.queryUserTradeAllList(reqDto);
    }

    @ControllerLog(description = "用户所有进NFT信息查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "用户所有进NFT信息查询")
    @PostMapping(value = {"queryUserTradeInList"})
    ResponseDto<GalaxyQueryUserTradeInListRespDto> queryUserTradeInList(GalaxyQueryUserTradeInListReqDto reqDto){
        return galaxyTradeQueryService.queryUserTradeInList(reqDto);
    }

    @ControllerLog(description = "用户所有出NFT信息查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "用户所有出NFT信息查询")
    @PostMapping(value = {"queryUserTradeOutList"})
    ResponseDto<GalaxyQueryUserTradeOutListRespDto> queryUserTradeOutList(GalaxyQueryUserTradeOutListReqDto reqDto){
        return galaxyTradeQueryService.queryUserTradeOutList(reqDto);
    }
}
