package com.liquidnet.service.adam.dto;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;

@ApiModel(value = "AdamAddressesParam", description = "添加/编辑收获地址入参")
@Data
public class AdamAddressesParam implements java.io.Serializable {
    private static final long serialVersionUID = -2626425843975309892L;
    @ApiModelProperty(position = 10, required = false, value = "收获地址ID，编辑时必传[64]")
    private String addressesId;
    @ApiModelProperty(position = 11, required = true, value = "姓名[50]", example = "Swagger")
    @Size(min = 1, max = 30, message = "姓名长度限制1-30位")
    private String name;
    @ApiModelProperty(position = 12, required = true, value = "手机号[11]", example = "13111111111")
    @Pattern(regexp = "\\d{11}", message = "手机号格式有误")
    @NotBlank(message = "手机号不能为空")
    private String phone;
    @ApiModelProperty(position = 13, required = true, value = "省份[30]", example = "北京")
    @Pattern(regexp = LnsRegex.Valid.CN_PCD, message = "省份必须为2～30位汉字")
    @NotBlank(message = "省份不能为空")
    private String province;
    @ApiModelProperty(position = 14, required = false, value = "省份行政编码[20]", example = "110000")
    private String provinceId;
    @ApiModelProperty(position = 15, required = true, value = "城市[30]", example = "北京城区")
    @Pattern(regexp = LnsRegex.Valid.CN_PCD, message = "城市必须为2～30位汉字")
    @NotBlank(message = "城市不能为空")
    private String city;
    @ApiModelProperty(position = 16, required = false, value = "城市行政编码[20]", example = "110100")
    private String cityId;
    @ApiModelProperty(position = 15, required = true, value = "区县[30]", example = "朝阳区")
    @Pattern(regexp = LnsRegex.Valid.CN_PCD, message = "区县必须为2～30位汉字")
    @NotBlank(message = "区县不能为空")
    private String county;
    @ApiModelProperty(position = 15, required = false, value = "区县行政编码[20]", example = "110101")
    private String countyId;
    @ApiModelProperty(position = 16, required = true, value = "详细地址[100]", example = "广渠路1号创1958园区")
    @Size(max = 100, message = "已超出详细地址长度限制")
    private String address;
}
