package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.utils.ShunfengSignUtils;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.*;
import com.liquidnet.service.kylin.dto.param.*;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.IKylinOrderExpress;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Service
@Slf4j
public class PerformancesExpressServiceImpl extends ServiceImpl<KylinOrderExpressMapper, KylinOrderExpress> implements IKylinOrderExpress {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private ShunfengSignUtils shunfengSignUtils;

    @Autowired
    private KylinPerformancesMapper performancesMapper;

    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    private KylinOrderExpressMapper kylinOrderExpressMapper;

    public List<PerformanceExpressPerformanceListAdminDao> getPerformancesList(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        List<PerformanceExpressPerformanceListAdminDao> voList = new ArrayList();
        try {
            Map<String, Object> map = BeanUtil.convertBeanToMap(performanceExpressSearchAdminParam);
            voList = performancesMapper.performanceExpressPerformanceList(map);
        } catch (Exception e) {
            return null;
        }
        return voList;
    }

    public List<PerformanceExpressPerformanceOrderListAdminDao> getPerformancesOrderList(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        List<PerformanceExpressPerformanceOrderListAdminDao> voList = new ArrayList();
        try {
            Map<String, Object> map = BeanUtil.convertBeanToMap(performanceExpressSearchAdminParam);
            voList = kylinOrderTicketsMapper.performanceExpressPerformanceOrderList(map);
        } catch (Exception e) {
            return null;
        }
        return voList;
    }

    public ResponseDto placeOrder(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        List<String> ids = performanceExpressSearchAdminParam.getIds();
        for (String orderTicketsId : ids) {
            KylinOrderTickets orderInfo = kylinOrderTicketsMapper.selectOne(
                    new QueryWrapper<KylinOrderTickets>().eq("order_tickets_id", orderTicketsId)
            );
            HashMap<String, Object> hBody = new HashMap<>();
            hBody.put("orderId", orderInfo.getOrderCode());

            hBody.put("jCompany", "摩登天空");
            hBody.put("jContact", "姜秀龙");
            // hBody.put("jTel", "010");
            hBody.put("jMobile", "15811009011");
            hBody.put("jProvince", "北京");
            hBody.put("jCity", "北京市");
            hBody.put("jAddress", "摩登天空");

            hBody.put("dContact", "张红梅");
            hBody.put("dMobile", "15010806631");
            hBody.put("dProvince", "北京");
            hBody.put("dCity", "北京市");
            hBody.put("dAddress", "华通大厦");

            hBody.put("custid", "7551234567");
            hBody.put("payMethod", 0);// 运费付款方式：0-寄付月结；1-寄付现结；2-收方付；3-第三方付；
            hBody.put("expressType", 1);// 顺丰特快

            hBody.put("depositumInfo", "票");
            hBody.put("depositumNo", 1);

            // 时间戳
            long currentTimeMillis = System.currentTimeMillis();

            // 生成签名并请求
            String result = shunfengSignUtils.generateSignatureAndRequest(currentTimeMillis + "", hBody, "/public/order/v1/placeOrder");
            HashMap hashMap = JsonUtils.fromJson(result, HashMap.class);
            System.out.println(result);
            if (hashMap.get("succ").equals("fail")) {
                String msg = (String) hashMap.get("msg");
                return ResponseDto.failure(msg);
            } else {
                KylinOrderExpress kylinOrderExpress = new KylinOrderExpress();
                String orderExpressId = IDGenerator.nextSnowId();
                kylinOrderExpress.setOrderExpressId(orderExpressId);
                kylinOrderExpress.setOrderTicketsId(orderTicketsId);
                kylinOrderExpress.setMailno((String) hashMap.get("mailno"));
                kylinOrderExpress.setExpressType(1);
                kylinOrderExpress.setFilterResult((Integer) hashMap.get("filter_result"));
                kylinOrderExpress.setRemark((String) hashMap.get("remark"));
                kylinOrderExpress.setOrigincode((String) hashMap.get("origincode"));
                kylinOrderExpress.setDestcode((String) hashMap.get("destcode"));
                kylinOrderExpress.setPrintIcon((String) hashMap.get("printIcon"));
                kylinOrderExpress.setPrintFlag((String) hashMap.get("printFlag"));
                kylinOrderExpress.setTwoDimensionCode((String) hashMap.get("twoDimensionCode"));
                kylinOrderExpress.setCreatedAt(DateUtil.getNowTime());
                kylinOrderExpressMapper.insert(kylinOrderExpress);
            }
        }
        return ResponseDto.success();
    }
}
