package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.liquidnet.service.candy.dto.CandyCouponCodeDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 用户券信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyUserCoupon implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String ucouponId;

    /**
     * ~candy_mgt_coupon.mcoupon_id
     */
    private String mcouponId;

    /**
     * ~adam_user.uid
     */
    private String uid;

    /**
     * ~candy_coupon.coupon_id
     */
    private String couponId;

    /**
     * 用户券状态[1-可用|2-无效｜3-已过期｜5-已使用]
     */
    private Integer state;

    /**
     * 兑换码
     */
    private String ccode;

    /**
     * 激活时间
     */
    private LocalDateTime bindAt;

    /**
     * 到期时间
     */
    private LocalDateTime duedAt;

    /**
     * 使用时间
     */
    private LocalDateTime usedAt;

    /**
     * 用于记录购买的内容
     */
    private String usedFor;

    /**
     * 操作人
     */
    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


    private static final CandyUserCoupon obj = new CandyUserCoupon();

    public static CandyUserCoupon getNew() {
        try {
            return (CandyUserCoupon) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyUserCoupon();
        }
    }
}
