package com.liquidnet.common.feign.interceptor;

import com.liquidnet.common.feign.constant.FeignConst;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.ServletUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.stereotype.Component;

@Component
public class SecuringRequestInterceptor implements RequestInterceptor {
    @Override
    public void apply(RequestTemplate requestTemplate) {
        if (requestTemplate.headers().containsKey(FeignConst.HEADER_INNER_REQUIRED)) {
            requestTemplate.header(CurrentUtil.uToken, ServletUtils.getRequest().getHeader(CurrentUtil.uToken));
        }
    }
}
