package com.liquidnet.service.account.funding.dto.base;

import com.liquidnet.service.account.common.FinConstants;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * FundingContextParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/20
 */
public class FundingContextParam implements Cloneable {
    private String currency;
    private String accAlias;
    // Subject ID
    private String finId;
    private String accGroupId;
    private String accType;
    private String accNo;
    private int accStatus;

    private BigDecimal amount;
    private FinConstants.CDType category;
    private String walletNo;
    private String transNo;
    private String tracingNo;
    private LocalDateTime tracingTime;

    private Map<String, List<String>> finIdWithAccNoMap;

    private LocalDateTime createTime;

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAccAlias() {
        return accAlias;
    }

    public void setAccAlias(String accAlias) {
        this.accAlias = accAlias;
    }

    public String getFinId() {
        return finId;
    }

    public void setFinId(String finId) {
        this.finId = finId;
    }

    public String getAccGroupId() {
        return accGroupId;
    }

    public void setAccGroupId(String accGroupId) {
        this.accGroupId = accGroupId;
    }

    public String getAccType() {
        return accType;
    }

    public void setAccType(String accType) {
        this.accType = accType;
    }

    public String getAccNo() {
        return accNo;
    }

    public void setAccNo(String accNo) {
        this.accNo = accNo;
    }

    public int getAccStatus() {
        return accStatus;
    }

    public void setAccStatus(int accStatus) {
        this.accStatus = accStatus;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public FinConstants.CDType getCategory() {
        return category;
    }

    public void setCategory(FinConstants.CDType category) {
        this.category = category;
    }

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public String getTransNo() {
        return transNo;
    }

    public void setTransNo(String transNo) {
        this.transNo = transNo;
    }

    public String getTracingNo() {
        return tracingNo;
    }

    public void setTracingNo(String tracingNo) {
        this.tracingNo = tracingNo;
    }

    public LocalDateTime getTracingTime() {
        return tracingTime;
    }

    public void setTracingTime(LocalDateTime tracingTime) {
        this.tracingTime = tracingTime;
    }

    public Map<String, List<String>> getFinIdWithAccNoMap() {
        return finIdWithAccNoMap;
    }

    public void setFinIdWithAccNoMap(Map<String, List<String>> finIdWithAccNoMap) {
        this.finIdWithAccNoMap = finIdWithAccNoMap;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    private static final FundingContextParam obj = new FundingContextParam();

    public static FundingContextParam getNew() {
        try {
            return (FundingContextParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new FundingContextParam();
    }
}
