package com.liquidnet.service.stone.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.stone.constant.StoneConstant;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.entity.StoneScoreLogs;
import com.liquidnet.service.stone.vo.StoneOrderListVo;
import com.liquidnet.service.stone.vo.StoneUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class StoneRedisUtils {

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private StoneMongoUtils mongoUtils;

    /**
     * 获取 积分物品 剩余库存
     *
     * @param itemId ID
     * @return
     */
    public Integer getStoneGeneralSurplus(String itemId) {
        String redisKey = StoneConstant.ITEM.concat(itemId).concat(StoneConstant.SURPLUS_GENERAL);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return 0;
        } else {
            return (Integer) obj;
        }
    }

    /**
     * 修改 积分物品 库存
     *
     * @param itemId  ID
     * @param general 改变量
     * @return
     */
    public Integer changeStoneGeneralSurplus(String itemId, Integer general) {
        String redisKey = StoneConstant.ITEM.concat(itemId).concat(StoneConstant.SURPLUS_GENERAL);
        long result;
        if (general > 0) {
            result = redisUtil.incr(redisKey, general);
        } else {
            result = redisUtil.decr(redisKey, Math.abs(general));
        }
        return (int) result;
    }

    /**
     * 获取 用户积分 可用
     *
     * @param uid ID
     * @return
     */
    public Integer getUserScoreRest(String uid) {
        String redisKey = StoneConstant.USER.concat(uid).concat(StoneConstant.SURPLUS_SCORE);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return 0;
        } else {
            return (Integer) obj;
        }
    }

    /**
     * 获取 用户积分 可用
     *
     * @param uid ID
     * @return
     */
    public Integer getUserScoreUse(String uid) {
        String redisKey = StoneConstant.USER.concat(uid).concat(StoneConstant.USE_SCORE);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return 0;
        } else {
            return (Integer) obj;
        }
    }

    /**
     * 修改 用户积分 使用
     *
     * @param uid ID
     * @return
     */
    public Integer changeUserScoreUse(String uid, Integer general) {
        String redisKey = StoneConstant.USER.concat(uid).concat(StoneConstant.USE_SCORE);
        long result;
        if (general > 0) {
            result = redisUtil.incr(redisKey, general);
        } else {
            result = redisUtil.decr(redisKey, Math.abs(general));
        }
        return (int) result;
    }

    /**
     * 修改 用户积分 剩余
     *
     * @param uid ID
     * @return
     */
    public Integer changeUserScoreRest(String uid, Integer general) {
        String redisKey = StoneConstant.USER.concat(uid).concat(StoneConstant.SURPLUS_SCORE);
        long result;
        if (general > 0) {
            result = redisUtil.incr(redisKey, general);
        } else {
            result = redisUtil.decr(redisKey, Math.abs(general));
        }
        return (int) result;
    }

    /**
     * 设置 积分物品 缓存
     *
     * @param itemId
     * @param data
     */
    public void setItemData(String itemId, StoneScoreItems data) {
        String redisKey = StoneConstant.ITEM.concat(itemId);
        redisUtil.set(redisKey, data);
    }

    /**
     * 获取 积分物品 缓存
     *
     * @param itemId
     */
    public StoneScoreItems getItemData(String itemId) {
        String redisKey = StoneConstant.ITEM.concat(itemId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return mongoUtils.itemGet(itemId);
        } else {
            return (StoneScoreItems) obj;
        }
    }


//    /**
//     * 修改 积分物品 缓存list
//     *
//     * @param data
//     */
//    public void updateItemDataList(StoneScoreItems data) {
//        String redisKey = StoneConstant.ITEM_LIST;
//        Object obj = redisUtil.get(redisKey);
//        List<StoneScoreItems> dataList;
//        if (obj == null) {
//            dataList = mongoUtils.itemList();
//        } else {
//            dataList = (List<StoneScoreItems>) obj;
//        }
//        for (int i = 0; i < dataList.size(); i++) {
//            StoneScoreItems items = dataList.get(i);
//            if (items.getItemId().equals(data.getItemId())) {
//                dataList.set(i, items);
//                break;
//            }
//        }
//        redisUtil.set(redisKey, dataList);
//    }

    /**
     * 添加 积分日志 缓存list
     *
     * @param data
     */
    public void addLogsList(String uid, StoneScoreLogs data) {
        String redisKey = StoneConstant.LOGS_LIST.concat(uid);
        Object obj = redisUtil.get(redisKey);
        List<StoneScoreLogs> dataList;
        if (obj == null) {
            dataList = (List<StoneScoreLogs>) mongoUtils.logList(uid, 1, 40).get("data");
        } else {
            dataList = (List<StoneScoreLogs>) obj;
        }
        dataList.add(0, data);
        if (dataList.size() > 40) {
            int size = dataList.size() - 40;
            for (int i = 0; i < size; i++) {
                dataList.remove(40);
            }
        }
        redisUtil.set(redisKey, dataList);
    }

    /**
     * 获取 积分日志 缓存list
     */
    public List<StoneScoreLogs> getLogsList(String uid) {
        String redisKey = StoneConstant.LOGS_LIST.concat(uid);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            List<StoneScoreLogs> getLogsList = (List<StoneScoreLogs>) mongoUtils.logList(uid, 1, 40).get("data");
            redisUtil.set(redisKey,getLogsList);
            return getLogsList;
        } else {
            return (List<StoneScoreLogs>) obj;
        }
    }

    /**
     * 设置 用户任务 缓存
     *
     * @param uid
     * @param data
     */
    public void setUserData(String uid, StoneUserVo data) {
        String redisKey = StoneConstant.USER.concat(uid);
        redisUtil.set(redisKey, data);
    }

    /**
     * 获取 用户任务 缓存
     *
     * @param uid
     */
    public StoneUserVo getUserData(String uid) {
        String redisKey = StoneConstant.USER.concat(uid);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return mongoUtils.userGet(uid);
        } else {
            return (StoneUserVo) obj;
        }
    }

    /**
     * 获取商品 购买数量
     *
     * @param uid
     * @param itemId
     * @return
     */
    public int getItemLimit(String uid, String itemId) {
        String redisKey = StoneConstant.ITEM_LIMIT.concat(uid).concat(":" + itemId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return 0;
        } else {
            return (int) obj;
        }
    }

    /**
     * 添加商品 购买数量
     *
     * @param uid
     * @param itemId
     * @param number
     */
    public void addItemLimit(String uid, String itemId, Integer number) {
        String redisKey = StoneConstant.ITEM_LIMIT.concat(uid).concat(":" + itemId);
        redisUtil.incr(redisKey, number);
    }

    /**
     * 添加 积分订单列表数据
     *
     * @param uid
     * @param data
     */
    public void addOrderList(String uid, StoneOrderListVo data) {
        String redisKey = StoneConstant.ORDER_LIST.concat(uid);
        Object obj = redisUtil.get(redisKey);
        List<StoneOrderListVo> dataList;
        if (obj == null) {
            dataList = (List<StoneOrderListVo>) mongoUtils.orderList(uid, 1, 40).get("data");
        } else {
            dataList = (List<StoneOrderListVo>) obj;
        }
        dataList.add(0, data);
        if (dataList.size() > 40) {
            int size = dataList.size() - 40;
            for (int i = 0; i < size; i++) {
                dataList.remove(40);
            }
        }
        redisUtil.set(redisKey, dataList);
    }

    /**
     * 覆盖 积分订单数据
     *
     * @param orderId
     * @param data
     */
    public void setOrderDetails(String orderId, StoneOrderListVo data) {
        String redisKey = StoneConstant.ORDER_DETAILS.concat(orderId);
        redisUtil.set(redisKey, data);
    }

    /**
     * 获取 订单 缓存list
     */
    public List<StoneOrderListVo> getOrderList(String uid) {
        String redisKey = StoneConstant.ORDER_LIST.concat(uid);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return (List<StoneOrderListVo>) mongoUtils.orderList(uid, 1, 40).get("data");
        } else {
            return (List<StoneOrderListVo>) obj;
        }
    }


    public boolean lockUid(String uid){
        String redisKey = StoneConstant.LOCK.concat(uid);
        return redisUtil.lock(uid,1,1);
    }

    public void unLockUid(String uid){
        String redisKey = StoneConstant.LOCK.concat(uid);
        redisUtil.uLock(redisKey);
    }
}
