package com.liquidnet.client.admin.web.controller.zhengzai.admin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.UpushTargetType;
import com.liquidnet.client.admin.zhengzai.admin.service.impl.AdminUpushServiceImpl;
import com.liquidnet.service.kylin.dao.UpushDetailsListDao;
import com.liquidnet.service.kylin.dto.param.admin.UpushParam;
import com.liquidnet.service.kylin.dto.param.admin.UpushSearchParam;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 友盟推送 后端管理控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-13
 */

@Controller
@RequestMapping("/admin/upush")
public class AdminUpushController extends BaseController {

    private String prefix = "zhengzai/admin/upush";

    @Value("${liquidnet.client.admin.platformUrl}")
    private String platformUrl;

    @Value("${liquidnet.url-banner.url5}")
    private String url5;
    @Value("${liquidnet.url-banner.url6}")
    private String url6;
    @Value("${liquidnet.url-banner.url7}")
    private String url7;
    @Value("${liquidnet.url-banner.url14}")
    private String url14;
    @Value("${liquidnet.url-banner.url20}")
    private String url20;
    @Value("${liquidnet.url-banner.url21}")
    private String url21;
    @Value("${liquidnet.url-banner.url22}")
    private String url22;
    @Value("${liquidnet.url-banner.url24}")
    private String url24;
    @Value("${liquidnet.url-banner.url26}")
    private String url26;

    @Autowired
    private AdminUpushServiceImpl adminUpushServiceImpl;

    @GetMapping("/create")
    public String create(ModelMap mmap) {
        List<Object> jumpType = UpushTargetType.getResultType();
        mmap.put("jumpType", jumpType);

        mmap.put("platformUrl", platformUrl);

        mmap.put("url5", url5);
        mmap.put("url6", url6);
        mmap.put("url7", url7);
        mmap.put("url14", url14);
        mmap.put("url20", url20);
        mmap.put("url21", url21);
        mmap.put("url22", url22);
        mmap.put("url24", url24);
        mmap.put("url26", url26);

        return prefix + "/create";
    }

    @RequiresPermissions("admin:upush:create")
    @PostMapping("create")
    @ResponseBody
    public AjaxResult createSave(UpushParam upushParam) {
        Boolean res = adminUpushServiceImpl.create(upushParam);
        if (res) {
            return success();
        } else {
            return error("添加失败");
        }
    }

    @RequiresPermissions("admin:upush:view")
    @GetMapping()
    public String upushs() {
        return prefix + "/upush";
    }

    @RequiresPermissions("admin:upush:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo upushList(UpushSearchParam upushSearchParam) {
        PageInfo<UpushDetailsListDao> result = adminUpushServiceImpl.lists(upushSearchParam);
        return getDataTable(result.getList());
    }

    @GetMapping("/detail/{upushId}")
    public String detail(@PathVariable("upushId") String upushId, ModelMap mmap) {
        UpushDetailsListDao result = null;
        result = adminUpushServiceImpl.detail(upushId);

        mmap.put("UpushDetailsListDao", result);

        return prefix + "/detail";
    }

}
