package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileSchoolParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileSchoolService;
import com.liquidnet.client.admin.zhengzai.smile.utils.SmileRedisUtils;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileSchoolVo;
import com.liquidnet.service.smile.entity.SmileSchool;
import com.liquidnet.service.smile.mapper.SmileSchoolMapper;
import com.liquidnet.service.smile.mapper.SmileUserMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Slf4j
@Service
public class SmileSchoolServiceImpl extends ServiceImpl<SmileSchoolMapper, SmileSchool> implements ISmileSchoolService {

    private Boolean redisSchoolTag = true;

    @Autowired
    SmileSchoolMapper smileSchoolMapper;

    @Autowired
    SmileUserMapper smileUserMapper;

    @Autowired
    SmileRedisUtils smileRedisUtils;

    @Override
    public PageInfo<SmileSchool> schoolList(SmileSchoolParam smileSchoolParam) {
        PageInfo<SmileSchool> pageInfo;
        try {
            Map<String,Object> map = BeanUtil.convertBeanToMap(smileSchoolParam);
            List<SmileSchool> smileSchools = smileSchoolMapper.selectSchoolList(map);
            pageInfo = new PageInfo<>(smileSchools);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return pageInfo;
    }

    @Override
    public SmileSchool getSchoolById(Long id) {
        return smileSchoolMapper.selectById(id);
    }

    @Override
    public AjaxResult create(SmileSchool smileSchool) {
        log.debug("smileSchool:{}", smileSchool);
        LambdaQueryWrapper<SmileSchool> queryWrapper = Wrappers.lambdaQuery(SmileSchool.class);
        queryWrapper.eq(SmileSchool::getName, smileSchool.getName());
        if (smileSchoolMapper.selectOne(queryWrapper) == null) {
            int id = smileSchoolMapper.insert(smileSchool);
            if (id > 0 && redisSchoolTag) {
                //查询二十个学校放入redis中
                updateSchoolRedis();
            }
            return AjaxResult.success();
        }
        return AjaxResult.warn("学校已存在");
    }


    @Override
    public AjaxResult updateSchoolById(SmileSchool smileSchool) {
        LambdaQueryWrapper<SmileSchool> queryWrapper = Wrappers.lambdaQuery(SmileSchool.class);
        queryWrapper.eq(SmileSchool::getId, smileSchool.getId());
        if (smileSchoolMapper.update(smileSchool, queryWrapper) > 0) {
            //更新User表  根据学校id修改用户学校名称
            smileUserMapper.updateUserSchoolBySchoolId(smileSchool.getId().toString(), smileSchool.getName());
            //更新redis
            updateSchoolRedis();
            return AjaxResult.success();
        }
        return AjaxResult.error();
    }


    private void updateSchoolRedis() {
        //查询20条学校数据
        List<SmileSchoolVo> smileSchoolVos = new ArrayList<>();
        smileSchoolMapper.selectListLimit().forEach(smileSchool -> {
            SmileSchoolVo smileSchoolVo = new SmileSchoolVo();
            try {
                BeanUtils.copyProperties(smileSchool,smileSchoolVo);
                smileSchoolVos.add(smileSchoolVo);
            }catch (Exception e) {
                e.printStackTrace();
            }
        });
        smileRedisUtils.set(SmileRedisConst.SMILE_SCHOOL, smileSchoolVos);
        if (smileSchoolVos.size() >= 20) {
            redisSchoolTag = false;
        }
    }


}
