package com.liquidnet.service.kylin.dto.vo.partner;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class ExpressModuleVo implements Serializable, Cloneable {

    @ApiModelProperty(value = "名称")
    private String title;

    @ApiModelProperty(value = "产品编码")
    private String productCode;

    @ApiModelProperty(value = "快递预估价格小")
    private BigDecimal estimatePriceMin;

    @ApiModelProperty(value = "快递预估价格大")
    private BigDecimal estimatePriceMax;

    private static final ExpressModuleVo obj = new ExpressModuleVo();

    public static ExpressModuleVo getNew() {
        try {
            return (ExpressModuleVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new ExpressModuleVo();
        }
    }
}
