package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetPerformanceShow;
import com.liquidnet.service.sweet.mapper.SweetPerformanceMapper;
import com.liquidnet.service.sweet.service.ISweetPerformanceAppService;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetPerformanceShowVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

@Service
public class SweetPerformanceAppServiceImpl extends ServiceImpl<SweetPerformanceMapper, SweetPerformanceShow> implements ISweetPerformanceAppService {
    @Autowired
    private RedisDataUtils redisUtils;

    @Override
    public ResponseDto<PageInfo<SweetPerformanceShowVo>> getlistInTime(Integer page, Integer size) {
        PageInfo<SweetPerformanceShowVo> pageInfo = null;
        try {
            size = 20;
            List<SweetPerformanceShowVo> data = new ArrayList<>();
//            PageHelper.startPage(page, size);
            LocalDateTime time = LocalDateTime.now();
            List<SweetPerformanceShow> performanceARList = redisUtils.getPerformanceAR();
            for (SweetPerformanceShow performanceShow : performanceARList) {
                if (time.isBefore(performanceShow.getTimeEnd()) && time.isAfter(performanceShow.getTimeStart()) && performanceShow.getStatus() == 1) {
                    SweetPerformanceShowVo vo = SweetPerformanceShowVo.getNew();
                    BeanUtils.copyProperties(performanceShow, vo);
                    vo.setTimeStart(DateUtil.Formatter.yyyyMMddHHmmss.format(performanceShow.getTimeStart()));
                    vo.setTimeEnd(DateUtil.Formatter.yyyyMMddHHmmss.format(performanceShow.getTimeEnd()));
                    data.add(vo);
                }
            }
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.success(pageInfo);
        }

    }
}
