package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.smile.entity.SmileVolunteersProject;
import com.liquidnet.service.smile.entity.SmileVolunteersTeam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * @author 志愿者活动创建修改
 */
@Data
public class SmileProjectDetailsVo implements Cloneable {
    @ApiModelProperty(value = "活动id", example = "")
    private String projectId;
    @ApiModelProperty(value = "项目名称", example = "")
    private String title;
    @ApiModelProperty(value = "开始时间", example = "")
    private String timeStart;
    @ApiModelProperty(value = "结束时间", example = "")
    private String timeEnd;
    @ApiModelProperty(value = "活动地址", example = "")
    private String address;
    @ApiModelProperty(value = "活动介绍", example = "")
    private String introduce;
    @ApiModelProperty(value = "封面图", example = "")
    private String img;
    @ApiModelProperty(value = "封面图", example = "")
    private String createdAt;
    @ApiModelProperty(value = "职责组集合", example = "")
    private List<SmileVolunteersTeam> teamArray;
    @ApiModelProperty(value = "职责组集合Vo", example = "")
    private List<SmileVolunteersTeamVo> teamVoArray;


    private static final SmileProjectDetailsVo obj = new SmileProjectDetailsVo();

    public static SmileProjectDetailsVo getNew() {
        try {
            return (SmileProjectDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SmileProjectDetailsVo();
        }
    }

    public SmileProjectDetailsVo copy(SmileVolunteersProject source, List<SmileVolunteersTeam> teamList) {
        this.setProjectId(source.getProjectId());
        this.setTitle(source.getTitle());
        this.setTimeStart(source.getTimeStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        this.setTimeEnd(source.getTimeEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        this.setAddress(source.getAddress());
        this.setIntroduce(source.getIntroduce());
        this.setImg(source.getImg());
        if (source.getCreatedAt() != null) {
            this.setCreatedAt(source.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        this.setTeamArray(teamList);
        return this;
    }
}
