package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtCouponInfoVo", description = "商铺活动:优惠券详情")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinStoreMgtCouponInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5779799640116243874L;
    @ApiModelProperty(position = 10, value = "卡券信息")
    private GoblinStoreCouponVo couponVo;
    @ApiModelProperty(position = 10, value = "关联商品信息[仅当`couponVo.useScope=1`，即部分商品时处理该数据]")
    private List<GoblinStoreMgtCouponSpuListVo> spuVoList;


    private static final GoblinStoreMgtCouponInfoVo obj = new GoblinStoreMgtCouponInfoVo();
    public static GoblinStoreMgtCouponInfoVo getNew() {
        try {
            return (GoblinStoreMgtCouponInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMgtCouponInfoVo();
        }
    }
}
