package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.goblin.dto.vo.GoblinStoreErpConfigVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;

import java.util.Map;

public interface IGoblinStoreMgtService {
    /**
     * 店铺管理:店铺信息:更新
     *
     * @param storeInfoVo GoblinStoreInfoVo
     * @return boolean
     */
    boolean updateStoreMgtInfo(GoblinStoreInfoVo storeInfoVo);

    /**
     * 店铺管理:店铺设置:编辑
     *
     * @param uid     UID
     * @param storeId 店铺ID
     * @param confMap 配置集合<key, value>
     * @return boolean
     */
    boolean updateStoreMgtConfig(String uid, String storeId, Map<String, String> confMap);

    /**
     * 店铺管理:店铺ERP配置:编辑
     *
     * @param uid              UID
     * @param storeErpConfigVo GoblinStoreErpConfigVo
     * @return boolean
     */
    boolean updateStoreMgtErpConfig(String uid, GoblinStoreErpConfigVo storeErpConfigVo);
}
