package com.liquidnet.service.chime.dto;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserRegisterRespDto
 * @Package com.liquidnet.service.chime.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/8 16:11
 */
@Data
public class ChimeUserRegisterRespDto {
    private String uuid;
    private String type;

    @ApiModelProperty(value = "创建时间")
//    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
//    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss.SSS", timezone = "GMT+8")
    private LocalDateTime created; //1630929604985

    @ApiModelProperty(value = "修改时间")
//    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
//    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss.SSS", timezone = "GMT+8")
    private LocalDateTime modified;

    private String username;
    private Boolean activated;
    private String nickname;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final ChimeUserRegisterRespDto obj = new ChimeUserRegisterRespDto();

    public static ChimeUserRegisterRespDto getNew() {
        try {
            return (ChimeUserRegisterRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new ChimeUserRegisterRespDto();
        }
    }

    public static void main(String[] args) {
        String ss = "{\"uuid\":\"3f6a2b20-1085-11ec-9941-bd3851758eda\",\"type\":\"user\",\"created\":1631092502233,\"modified\":1631092502233,\"username\":\"anjiabin5\",\"activated\":true,\"nickname\":\"anjiabin5-nickname\"}";
//        ChimeUserRegisterRespDto respDto = JsonUtils.fromJson(ss,ChimeUserRegisterRespDto.class);
        ChimeUserRegisterRespDto respDto = JSONObject.parseObject(ss,ChimeUserRegisterRespDto.class);
        System.out.println("ChimeUserRegisterRespDto==="+respDto.toString());
    }
}
