package com.liquidnet.service.dragon.channel.strategy.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.biz.DragonServiceCommonBiz;
import com.liquidnet.service.dragon.channel.strategy.IPayChannelStrategy;
import com.liquidnet.service.dragon.channel.strategy.biz.DragonPayBiz;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonOrdersDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.dto.DragonPayOrderQueryRespDto;
import com.liquidnet.service.dragon.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AbstractPayChannelStrategyImpl
 * @Package com.liquidnet.service.dragon.channel.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/16 13:04
 */
@Slf4j
public abstract class AbstractPayChannelStrategyImpl implements IPayChannelStrategy {
    @Autowired
    private DragonPayBiz dragonPayBiz;
    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private DragonServiceCommonBiz dragonServiceCommonBiz;

    @Override
    public abstract ResponseDto<DragonPayBaseRespDto> dragonPay(DragonPayBaseReqDto dragonPayBaseReqDto);

    @Override
    public abstract String dragonNotify(HttpServletRequest request, String payType, String deviceFrom);

    @Override
    public abstract DragonPayOrderQueryRespDto checkOrderStatus(String code);

    /**
     * 支付成功方法
     * @param dragonOrdersDto
     * @param bankTrxNo
     * @param timeEnd
     * @param bankReturnMsg
     */
    @Transactional(rollbackFor = Exception.class)
    protected boolean completeSuccessOrder(DragonOrdersDto dragonOrdersDto, String bankTrxNo, LocalDateTime timeEnd, String bankReturnMsg) {
        log.info("订单支付成功!");
        dragonOrdersDto.setPaymentAt(timeEnd);
        dragonOrdersDto.setPaymentId(bankTrxNo);// 设置银行流水号
        dragonOrdersDto.setStatus(Integer.parseInt(DragonConstant.PayStatusEnum.STATUS_PAID.getCode()));
        //更新缓存
        dataUtils.updateOrderStatus(dragonOrdersDto.getCode(),dragonOrdersDto);
        //修改订单状态
        dragonServiceCommonBiz.updateOrderStatus(dragonOrdersDto.getCode(),dragonOrdersDto.getStatus(),bankTrxNo);
        //通知商户
        return dragonPayBiz.sendNotify(dragonPayBiz.buildPayNotifyReqBo(dragonOrdersDto));
    }

    /**
     * 支付失败方法
     * @param dragonOrdersDto
     * @param bankReturnMsg
     */
    protected boolean completeFailOrder(DragonOrdersDto dragonOrdersDto, String bankReturnMsg) {
        log.info("订单支付失败!");
//        dragonOrdersDto.setPaymentAt(timeEnd);
//        dragonOrdersDto.setPaymentId(bankTrxNo);// 设置银行流水号
        dragonOrdersDto.setStatus(Integer.parseInt(DragonConstant.PayStatusEnum.STATUS_PAY_FAIL.getCode()));
        //更新缓存
        dataUtils.updateOrderStatus(dragonOrdersDto.getCode(),dragonOrdersDto);
        //修改订单状态
        dragonServiceCommonBiz.updateOrderStatus(dragonOrdersDto.getCode(),dragonOrdersDto.getStatus(),null);
        //通知商户
        return dragonPayBiz.sendNotify(dragonPayBiz.buildPayNotifyReqBo(dragonOrdersDto));
    }

}
