package com.liquidnet.service.galaxy.exception;

import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 自定义异常类
 * @class: GalaxyNftUserException
 * @Package com.liquidnet.service.galaxy.exception
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/5/12 13:44
 */
@Data
public class GalaxyNftUserException extends RuntimeException{
       private static final long serialVersionUID = -3916918823313768482L;
       private String code;
       private String message;

       public GalaxyNftUserException(String code, String message) {
             super(message);
             this.code = code;
             this.message = message;
       }

       public GalaxyNftUserException(String code, String message, Throwable t) {
             super(message, t);
             this.code = code;
             this.message = message;
       }
}

