package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "GoblinPayOrderDetailsVo", description = "NFT预下单订单详情")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinPayOrderDetailsVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -2564883531113300178L;

    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 13, value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "单品默认图片的URL[256]")
    private String skuPic;
    @ApiModelProperty(position = 21, value = "单品现价[20,2]")
    private BigDecimal price;

    @ApiModelProperty(value = "商铺名称")
    private String storeName;

    @ApiModelProperty(position = 22, value = "数量")
    private Integer num;
    @ApiModelProperty(position = 23, value = "总价")
    private BigDecimal priceTotal;

    private static final GoblinPayOrderDetailsVo obj = new GoblinPayOrderDetailsVo();

    public static GoblinPayOrderDetailsVo getNew() {
        try {
            return (GoblinPayOrderDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinPayOrderDetailsVo();
        }
    }

    public GoblinPayOrderDetailsVo copy(GoblinGoodsSkuInfoVo source) {
        if (null == source) return this;
        this.setSkuId(source.getSkuId());
        this.setSpuId(source.getSpuId());
        this.setName(source.getName());
        this.setSubtitle(source.getSubtitle());
        this.setSkuPic(source.getSkuPic());
        this.setPrice(source.getPrice());
        return this;
    }
}
