drop table if exists stone_score_logs;
create table stone_score_logs
(
    mid        bigint unsigned auto_increment primary key,
    logs_id varchar(64) default '' comment 'id',
    uid varchar(64) default '' comment '用户id',
    score decimal(8, 2) default 0 comment '积分',
    content varchar(255) default '' comment '积分动态明细',
    reason  varchar(255) default '' comment '变更原因',
    created_at datetime ,
    updated_at datetime ,
    comment    text
) engine = InnoDB comment '积分日志表';

drop table if exists stone_score_items;
create table stone_score_items
(
    mid        bigint unsigned auto_increment primary key,
    item_id varchar(64) default '' comment 'id',
    target_id   varchar(64) default '' comment '目标id',
    target_title   varchar(64) default '' comment '目标名称',
    type   integer default 0 comment '目标类型[1-券|1x-商品维度|2x-演出维度]',
    img varchar(255) default '' comment '展示图',
    score decimal(8, 2) default 0 comment '所需积分',
    price decimal(8, 2) default 0 comment '所需金额',
    general_total int default 0 comment '总库存[-999-不限]',
    general_surplus int default 0 comment '剩余库存',
    limit_count int default 0 comment '限购数量[0-不限]',
    details longtext default NULL comment '商品详情',
    notice longtext default NULL comment '注意事项',
    status int default 0 comment '状态[-999-全部-1-删除|0-未上架|1-已上架|2-定时上架]',
    start_time datetime NULL  COMMENT '定时上架-时间',
    end_time datetime NULL  COMMENT '定时下架-时间',
    created_at datetime ,
    updated_at datetime ,
    comment    text
) engine = InnoDB comment '积分物品表';

drop table if exists stone_score_user;
create table stone_score_user
(
    mid        bigint unsigned auto_increment primary key,
    score_id varchar(64) default '' comment 'id',
    uid varchar(64) default '' comment '用户id',
    status int default 1 comment '状态[1-正常|2-冻结]',
    created_at datetime ,
    updated_at datetime ,
    comment    text
) engine = InnoDB comment '积分用户表';

drop table if exists stone_score_order;
create table stone_score_order
(
    mid        bigint unsigned auto_increment primary key,
    order_id varchar(64) default '' comment 'id',
    uid                  varchar(64)      default '' comment '用户id',
    user_name            varchar(255)     NOT NULL DEFAULT '' COMMENT '用户昵称',
    user_mobile          varchar(255)     NOT NULL DEFAULT '' COMMENT '用户手机号',
    item_id              varchar(255)     NOT NULL DEFAULT '' COMMENT '积分物品id',
    target_title         varchar(255)     NOT NULL DEFAULT '' COMMENT '物品名称',
    order_code           varchar(255)     NOT NULL DEFAULT '' COMMENT '订单号',
    number               int(32)          NOT NULL DEFAULT 0 COMMENT '数量',
    price                decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '单价',
    score                decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '积分',
    price_express        decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '快递价格',
    price_actual         decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '实付价格',
    pay_type             varchar(255)     NOT NULL DEFAULT '' COMMENT '选择支付方式[SCORE-积分]',
    payment_type         varchar(255)     NULL     DEFAULT '' COMMENT '实际支付方式[SCORE-积分]',
    payment_id           varchar(255)     NULL     DEFAULT '' COMMENT '支付的订单号',
    time_pay             varchar(255)     NULL     DEFAULT '' COMMENT '支付时间',
    pay_countdown_minute int(32)          NOT NULL DEFAULT 15 COMMENT '订单过期时间(分钟)',
    status                 tinyint        NOT NULL DEFAULT 0 COMMENT '订单状态[0-待付款|1-已付款|2-已关闭|3-正在退款|4-已退款|5-待关闭|6-部分退款]',
    pay_status             tinyint        NOT NULL DEFAULT 0 COMMENT '支付状态[0-未支付|1-已支付|2-支付失败]',
    created_at datetime ,
    updated_at datetime ,
    comment    text
) engine = InnoDB comment '积分订单表';