package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "GoblinNftGoodsSkuInfoVo", description = "NFT商品SKU信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftGoodsSkuInfoVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -519573757075729441L;

    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 13, value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "单品默认图片的URL[256]")
    private String skuPic;
    @ApiModelProperty(position = 15, value = "单品详情展示文件URL[256]")
    private String skuWatch;

    @ApiModelProperty(position = 18, value = "单品库存")
    private Integer skuStock;

    @ApiModelProperty(position = 20, value = "单品销售价-原价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 21, value = "单品现价[20,2]")
    private BigDecimal price;

    @ApiModelProperty(position = 23, value = "单品简介[256]", example = "单品简介...")
    private String intro;
    @ApiModelProperty(position = 23, value = "单品详情", example = "单品详情...")
    private String details;

    @ApiModelProperty(position = 26, value = "限量 0无限制 X限购数量")
    private Integer buyLimit;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 27, value = "开售时间")
    private LocalDateTime saleStartTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 27, value = "停售时间")
    private LocalDateTime saleStopTime;

    @ApiModelProperty(position = 33, value = "自定义展示[0-默认展示|1-隐藏不可购买]")
    private String skuAppear;

    @ApiModelProperty(position = 54, value = "单品音乐人标签[藏品类型时使用]")
    private List<GoblinGoodsExtagVo> extagVoList;

    @ApiModelProperty(position = 55, value = "spu相关信息")
    private GoblinNftGoodsSpuInfoVo goblinNftGoodsSpuInfoVo;

    @ApiModelProperty(position = 56, value = "是否还有库存 0没有库存 1有库存 即售罄")
    private int isStock;
    @ApiModelProperty(position = 57, value = "当前用户还可以购买数量 有限购的时候用")
    private int canBuyNum;

    private static final GoblinNftGoodsSkuInfoVo obj = new GoblinNftGoodsSkuInfoVo();

    public static GoblinNftGoodsSkuInfoVo getNew() {
        try {
            return (GoblinNftGoodsSkuInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftGoodsSkuInfoVo();
        }
    }

    public GoblinNftGoodsSkuInfoVo copy(GoblinGoodsSkuInfoVo source) {
        if (null == source) return this;
        this.setSkuId(source.getSkuId());
        this.setSpuId(source.getSpuId());
        this.setName(source.getName());
        this.setSubtitle(source.getSubtitle());
        this.setSkuPic(source.getSkuPic());
        this.setSkuWatch(source.getSkuWatch());
        this.setSkuStock(source.getSkuStock());
        this.setSellPrice(source.getSellPrice());
        this.setPrice(source.getPrice());
        this.setIntro(source.getIntro());
        this.setDetails(source.getDetails());
        this.setBuyLimit(source.getBuyLimit());
        this.setSaleStartTime(source.getSaleStartTime());
        this.setSaleStopTime(source.getSaleStopTime());
        this.setSkuAppear(source.getSkuAppear());
        this.setExtagVoList(source.getExtagVoList());
        return this;
    }
}
