package com.liquidnet.service.controller;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.manage.SmileFrontService;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.util.SmileRedisUtils;
import com.liquidnet.service.util.Utils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangfuxin
 * @Description:用户接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理(需要登陆状态)")
@RestController
@RequestMapping("/front")
@Slf4j
public class SmileUserController {
    @Autowired
    private SmileRedisUtils smileRedisUtils;
    @Autowired
    private SmileFrontService smileFrontService;
    @Autowired
    private Utils utils;

    @GetMapping("getUser")
    @ApiOperation("获取用户状态，如果没查到，则返回null")
    public ResponseDto<SmileUserVO> getUser() {
        String userId = CurrentUtil.getCurrentUid();
        SmileUserVO smileUserVO=smileRedisUtils.getSmileUserVo(userId);
        return ResponseDto.success(smileUserVO);
    }
    @GetMapping("getSchool")
    @ApiOperation("获得学校")
    public ResponseDto<List<SmileSchoolVo>> getSchool() {
       /* String userId = CurrentUtil.getCurrentUid();
        List<SmileSchoolVo> list=null;
        if(redisUtil.hasKey(SmileRedisConst.SMILE_SCHOOL)){
            list= (List<SmileSchoolVo>) redisUtil.get(SmileRedisConst.SMILE_SCHOOL);
        }*/
        return ResponseDto.success(smileRedisUtils.getSchool());
    }
    @GetMapping("getPerformance")
    @ApiOperation("获得演出列表")
    public ResponseDto<List<KylinPerformanceVo>> getPerformance() {
        return ResponseDto.success(smileFrontService.getPerformance());
    }
   /* @GetMapping("repeatAuth")
    @ApiOperation("重新认证")
    public ResponseDto repeatAuth() {
        String userId = CurrentUtil.getCurrentUid();
        //判断是否认证了。
        SmileUserVO smileUserVORedis= smileRedisUtils.getSmileUserVo(userId);
        if(null!=smileUserVORedis&&null!= smileUserVORedis.getType()&&(smileUserVORedis.getType()==2||smileUserVORedis.getType()==1)){
            return ResponseDto.failure("该用户已认证!");
        }
        smileRedisUtils.del(SmileRedisConst.SMILE_USER.concat(userId));
        smileFrontService.deleteUser(userId);
        return ResponseDto.success();
    }*/
  /*  @GetMapping("repeatCommit")
    @ApiOperation("重新提交")
    public ResponseDto repeatCommit() {
        String userId = CurrentUtil.getCurrentUid();
        //判断是否认证了。
        SmileUserVO smileUserVORedis= smileRedisUtils.getSmileUserVo(userId);
        if(null!=smileUserVORedis&&null!= smileUserVORedis.getType()&&(smileUserVORedis.getType()==2||smileUserVORedis.getType()==1)){
            return ResponseDto.failure("该用户已认证!");
        }
        smileUserVORedis.setAuthStatus(0);
        smileRedisUtils.setSmileUserVo(userId,smileUserVORedis);
        return ResponseDto.success();
    }*/
    @GetMapping("auth")
    @ApiOperation("认证")
    public ResponseDto auth() {
        String userId = CurrentUtil.getCurrentUid();
        SmileUserVO smileUserVORedis=  smileRedisUtils.getSmileUserVo(userId);
        if(null!=smileUserVORedis){
            if(smileUserVORedis.getAuthStatus()==1&&null!=smileUserVORedis.getType()&&(smileUserVORedis.getType()==1||smileUserVORedis.getType()==2)){
                return ResponseDto.success(true);
            } else{
                if(!(smileUserVORedis.getTag().contains("1")&&smileUserVORedis.getTag().contains("2")&&smileUserVORedis.getTag().contains("3"))){
                   return ResponseDto.failure("用户信息不全，请填写后提交认证");
                }
                if(null!=smileUserVORedis.getType()&&smileUserVORedis.getType()==4){
                    smileFrontService.deleteUser(userId);
                }
                smileUserVORedis.setAuthStatus(1);
                smileUserVORedis.setType(0);
                smileRedisUtils.setSmileUserVo(userId,smileUserVORedis);
                //redisUtil.set(SmileRedisConst.SMILE_USER.concat(userId),smileUserVORedis);
                return ResponseDto.success(smileFrontService.auth(userId,smileUserVORedis));
            }
        }
        return ResponseDto.failure("没有该用户信息");
    }


    //
    @PostMapping("saveOrUpdateUserOneStep")
    @ApiOperation("增加或者删除第一步")
    public ResponseDto saveOrUpdateUserOneStep(@Validated(SmileUserVO.saveOne.class) @RequestBody  SmileUserVO smileUserVO, MethodArgumentNotValidException exception) {
        BindingResult result = exception.getBindingResult();
        if (result!=null&&result.hasErrors()) {
            List<ObjectError> errors = result.getAllErrors();
            if (errors != null) {
                return  ResponseDto.failure(errors.get(0).getDefaultMessage());
            }
        }
        String userId = CurrentUtil.getCurrentUid();

        SmileUserVO smileUserVORedis= smileRedisUtils.getSmileUserVo(userId);
        smileUserVO.setUid(userId);
        if(null!=smileUserVORedis&&null!=smileUserVORedis.getType()&&(smileUserVORedis.getType()==1||smileUserVORedis.getType()==2)){
            //说明已经验证过
            return ResponseDto.failure("用户状态不对");
        }
        smileUserVO.setTag("1");
        smileFrontService.saveOrUpdateUser(smileUserVO,smileUserVORedis,"1");
        return  ResponseDto.success();
    }

    @PostMapping("saveOrUpdateUserTwoStep")
    @ApiOperation("增加或者删除第二步")
    public ResponseDto saveOrUpdateUserTwoStep(@Validated(SmileUserVO.saveTwo.class)@RequestBody SmileUserVO smileUserVO, MethodArgumentNotValidException exception) {
        BindingResult result = exception.getBindingResult();
        if (result!=null&&result.hasErrors()) {
            List<ObjectError> errors = result.getAllErrors();
            if (errors != null) {
                return  ResponseDto.failure(errors.get(0).getDefaultMessage());
            }
        }
        if(StringUtil.isNotBlank(smileUserVO.getIdCard())&&StringUtil.isNotBlank(smileUserVO.getName())){
            String userId = CurrentUtil.getCurrentUid();
            if(utils.validate(smileUserVO.getName(),smileUserVO.getIdCard())){
                smileUserVO.setUid(userId);
                SmileUserVO smileUserVORedis=smileRedisUtils.getSmileUserVo(userId);
                if(null!=smileUserVORedis&&null!=smileUserVORedis.getType()&&(smileUserVORedis.getType()==1||smileUserVORedis.getType()==2)){
                    //说明已经验证过
                    return ResponseDto.failure("用户状态不对");
                }
                smileUserVO.setTag("2");
                smileFrontService.saveOrUpdateUser(smileUserVO,smileUserVORedis,"2");
            }else {
                return  ResponseDto.failure("验证身份证失败！");
            }
        }

        return  ResponseDto.success();
    }

    @PostMapping("saveOrUpdateUserThreeStep")
    @ApiOperation("增加或者删除第三步")
    public ResponseDto saveOrUpdateUserThreeStep(@Validated(SmileUserVO.saveThree.class) @RequestBody SmileUserVO smileUserVO, MethodArgumentNotValidException exception) {
        BindingResult result = exception.getBindingResult();
        if (result!=null&&result.hasErrors()) {
            List<ObjectError> errors = result.getAllErrors();
            if (errors != null) {
                return  ResponseDto.failure(errors.get(0).getDefaultMessage());
            }
        }
        String userId = CurrentUtil.getCurrentUid();
        smileUserVO.setUid(userId);
        SmileUserVO smileUserVORedis=  smileRedisUtils.getSmileUserVo(userId);
        if(null!=smileUserVORedis&&null!=smileUserVORedis.getType()&&(smileUserVORedis.getType()==1||smileUserVORedis.getType()==2)){
            //说明已经验证过
            return ResponseDto.failure("用户状态不对");
        }
        smileUserVO.setTag("3");
        smileFrontService.saveOrUpdateUser(smileUserVO,smileUserVORedis,"3");
        return  ResponseDto.success();
    }

    @GetMapping("getSellDataOne")
    @ApiOperation("获取销售数据")
    public ResponseDto<SmileSellDataVO> getSellDataOne(@RequestParam String performanceId) {
        String userId = CurrentUtil.getCurrentUid();
        SmileSellDataVO smileSellDataVO = smileRedisUtils.getSellDataVo(userId,performanceId);
        return  ResponseDto.success(smileSellDataVO);
    }
    @GetMapping("getSellDataTwo")
    @ApiOperation("获取XX票订单数据")
    public ResponseDto<SmileSellDataDetailVO> getSellDataDetail(@RequestParam String ticketId, String activeName, String ticketName) {
        String userId = CurrentUtil.getCurrentUid();
        log.debug("用户id{}",userId);
        SmileSellDataDetailVO smileSellDataDetailVO1 =smileFrontService.getSellDataDetail(userId,ticketId,activeName,ticketName);
        return  ResponseDto.success(smileSellDataDetailVO1);
    }
    @GetMapping("getCommission")
    @ApiOperation("获取佣金明细")
    public ResponseDto<CommissionVO> getCommission() {
        String userId = CurrentUtil.getCurrentUid();
        log.debug("用户id{}",userId);
        CommissionVO commissionVO= smileRedisUtils.getCommissionVO(userId);
        return  ResponseDto.success(commissionVO);
    }



}
