package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 轮播图
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@ApiModel(value = "GoblinFrontBannerBuildParam", description = "轮播图param")
@Data
public class GoblinFrontBannerVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    private Long mid;

    /**
     * 图片路径
     */
    @ApiModelProperty(value = "图片路径")
    private String picUrl;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer indexs;

    /**
     * 1、票务2、H5
     */
    @ApiModelProperty(value = "1、票务2、H5")
    private String jumpType;

    /**
     * 开启时间
     */
    @ApiModelProperty(value = "开启时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime endTime;

    /**
     * 活动url
     */
    @ApiModelProperty(value = "活动url")
    private String activityUrl;

    /**
     * 票务名字
     */
    @ApiModelProperty(value = "票务名字")
    private String ticketName;

    /**
     * 1、首页顶部位置2、首页中部位置
     */
    @ApiModelProperty(value = "1、首页顶部位置2、首页中部位置")
    private Integer bannerType;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updateTime;

    /**
     * bannerId
     */
    @ApiModelProperty(value = "bannerId")
    private String bannerId;

    /**
     * 0未删除1已删除
     */
    @ApiModelProperty(value = "0未删除1已删除")
    private Integer delTag;
    @ApiModelProperty(value = "ticketId，有可能是spuid")
    private String ticketId;
    private static final GoblinFrontBannerVo obj = new GoblinFrontBannerVo();

    public static GoblinFrontBannerVo getNew() {
        try {
            return (GoblinFrontBannerVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinFrontBannerVo();
        }
    }

}
