package com.liquidnet.service.slime.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.slime.dto.vo.SlimeStationsVo;
import com.liquidnet.service.slime.service.ISlimeStationsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 小站 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-01
 */
@ApiSupport(order = 10000)
@Api(tags = "首页小站")
@Slf4j
@Validated
@RestController
@RequestMapping("stations")
public class SlimeStationsController {

    @Autowired
    ISlimeStationsService slimeStationsService;

    @ApiOperationSupport(order = 10)
    @ApiOperation(value = "默认小站列表")
    @GetMapping("list")
    public ResponseDto<List<SlimeStationsVo>> stationsList() {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(slimeStationsService.stationsList(currentUid));
    }
}
