package com.liquidnet.service.sweet.controller;

import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.SweetTestImpl;
import com.liquidnet.service.sweet.service.impl.SweetWechatMaoDengServiceImpl;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetMaoDengVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@Api(tags = "活动-猫登活动")
@RestController
@RequestMapping("/wechatMaoDeng")
@Slf4j
public class SweetWechatMaoDengController {

    @Autowired
    private WechatUsersRedisUtils redisUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    private SweetWechatMaoDengServiceImpl sweetWechatMaoDengService;
    @Autowired
    private SweetTestImpl sweetTestImpl;


    @GetMapping("/backData")
    @ApiOperation("返回文字图片")
    public ResponseDto<SweetMaoDengVo> backDatas(String userId){


        SweetMaoDengVo sweetMaoDeng = redisUtils.getSweetMaoDengTransfer(userId);
        if (sweetMaoDeng!=null){
        String textMsg = sweetMaoDeng.getTextMsg();
        String image = sweetMaoDeng.getPicUrl();
        if (StringUtil.isEmpty(textMsg) && StringUtil.isEmpty(image)) {
            return ResponseDto.failure("90081", "获取信息失败");
        }

        return ResponseDto.success(sweetMaoDeng);
        }
        return ResponseDto.failure("获取信息失败");
    }

    @PostMapping("/backData")
    @ApiOperation("存生成的图")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "userId", value = "userId"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "imgUrl", value = "imgUrl"),
    })
    public ResponseDto addBuilderImg(@RequestParam(value = "userId",required = false) String userId,
                                     @RequestParam(value = "imgUrl",required = false)String imgUrl){
        return sweetWechatMaoDengService.addBuilderImg(userId,imgUrl);
    }

    @GetMapping("sensitiveText")
    @ApiOperation("入库测试-文本")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "fromUser", value = "fromUser"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "maoContent", value = "maoContent"),
    })
    public ResponseDto<Boolean> insertText(String fromUser,String maoContent){
        sweetTestImpl.insertToText(fromUser,maoContent);

        return ResponseDto.failure();
    }

    @GetMapping("sensitiveImg")
    @ApiOperation("入库测试-图片")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "fromUser", value = "fromUser"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picUrl", value = "picUrl")
    })
    public ResponseDto<Boolean> insertImg(String fromUser,String picUrl){
        sweetTestImpl.insertToImg(fromUser,picUrl);
        return ResponseDto.failure();
    }

}
