package com.liquidnet.service.goblin.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinUserNftAccInfoVo", description = "数字账户开通信息")
@Data
public class GoblinUserNftAccInfoVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 9036417838200526658L;

    @ApiModelProperty(position = 11, value = "状态码")
    private String code;
    @ApiModelProperty(position = 12, value = "提示信息")
    private String msg;
    @ApiModelProperty(position = 13, value = "最后操作的时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime time;

    private static final GoblinUserNftAccInfoVo obj = new GoblinUserNftAccInfoVo();

    public static GoblinUserNftAccInfoVo getNew() {
        try {
            return (GoblinUserNftAccInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserNftAccInfoVo();
        }
    }
}
