package com.liquidnet.client.admin.common.enums;

import java.util.*;

/**
 * <p>
 * 友盟推送 跳转类型
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-13
 */
public enum UpushTargetType {

    TARGET_TYPE5("场地详情", 5),
    TARGET_TYPE6("票务详情", 6),
    TARGET_TYPE7("商品详情", 7),
    TARGET_TYPE14("商品集合", 14),
    TARGET_TYPE20("音乐人详情", 20),
    TARGET_TYPE21("歌曲详情", 21),
    TARGET_TYPE22("专辑详情", 22),
    TARGET_TYPE24("音乐人集合", 24),
    TARGET_TYPE26("摩登会员", 26),

    TARGET_TYPE12("活动跳转-可分享", 12),
    TARGET_TYPE100("活动跳转", 100),
    TARGET_TYPE0("不跳转", 0),

    TARGET_TYPE16("票务首页", 16),
    TARGET_TYPE17("商品首页", 17),
//    TARGET_TYPE28("消息列表", 28),
    TARGET_TYPE32("系统消息列表", 32);
//    TARGET_TYPE33("会员消息列表", 33);

    private String name;
    private int index;

    UpushTargetType(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    private static List<Object> resultTypeListR = null;

    static {
        ArrayList<Object> resultTypeList = new ArrayList<>();
        for (UpushTargetType resultType : UpushTargetType.values()) {
            Map<String, Object> mapTemp = new HashMap<>();
            mapTemp.put("id", resultType.index);
            mapTemp.put("name", resultType.name);
            resultTypeList.add(mapTemp);
        }
        resultTypeListR = Collections.unmodifiableList(resultTypeList);
    }

    public static List<Object> getResultType() {
        return resultTypeListR;
    }

    public static String getTypeName(int index) {
        for (UpushTargetType c : UpushTargetType.values()) {
            if (c.getIndex() == index) {
                return c.name;
            }
        }
        return null;
    }
}
