package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 友盟消息推送
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdminUpush implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * upush_id
     */
    private String upushId;

    /**
     * 推送设备all ios android
     */
    private Integer pushRange;

    /**
     * 推送号码
     */
    private String mobile;

    /**
     * 推送标题
     */
    private String pushTitle;

    /**
     * 推送内容
     */
    private String pushContent;

    /**
     * 封面图
     */
    private String img;

    /**
     * 跳转类型 go_app,go_channel,go_super_channel,normal_play,normal_live,ugc_play,ugc_live,ad_link,promotion,ticket,tour,goods,area
     */
    private Integer jumpType;

    /**
     * 跳转值
     */
    private String jumpValue;

    /**
     * 跳转对应的值
     */
    private String jumpContent;

    /**
     * 推送时间
     */
    private String pushTime;

    /**
     * 是否发送推送消息，2不发送 1发送推送消息
     */
    private Integer isPush;

    /**
     * 发送类型，2立即发送 1定时发送
     */
    private Integer sendType;

    /**
     * 消息类型，2系统消息 1会员消息
     */
    private Integer messageType;

    /**
     * 用户类型，2全部用户 1指定手机号
     */
    private Integer specifyType;

    /**
     * 消息展示类型，2普通文本，1图文排版
     */
    private Integer messageShowType;

    /**
     * 推送者ID
     */
    private String pushedBy;

    /**
     * 推送者姓名
     */
    private String pushedName;

    /**
     * 推送任务ID
     */
    private String taskId;
    private String msgId;
    private String errorCode;
    private String errorMsg;

    private String createdAt;

    private String updatedAt;


}
