package com.liquidnet.service.dragon.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
public class DragonOrders implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * status
     */
    private Integer status;

    /**
     * code
     */
    private String code;

    /**
     * type
     */
    private String type;

    /**
     * price
     */
    private BigDecimal price;

    /**
     * name
     */
    private String name;

    /**
     * detail
     */
    private String detail;

    /**
     * order_code
     */
    private String orderCode;

    /**
     * client_ip
     */
    private String clientIp;

    /**
     * notify_url
     */
    private String notifyUrl;

    /**
     * payment_type
     */
    private String paymentType;

    /**
     * payment_id
     */
    private String paymentId;

    /**
     * payment_at
     */
    private LocalDateTime paymentAt;

    /**
     * finished_at
     */
    private LocalDateTime finishedAt;

    /**
     * created_at
     */
    private LocalDateTime createdAt;

    /**
     * updated_at
     */
    private LocalDateTime updatedAt;

    /**
     * deleted_at
     */
    private LocalDateTime deletedAt;

}
