package com.liquidnet.service.chime.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.chime.dto.ChimeUserInfoDto;
import com.liquidnet.service.chime.dto.ChimeUserRegisterReqDto;
import com.liquidnet.service.chime.dto.ChimeUserUpdateReqDto;
import com.liquidnet.service.chime.service.IChimeUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 社交用户控制类
 * @class: ChimeUserController
 * @Package com.liquidnet.service.chime.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/8 15:43
 */
@Api(tags = "在场-用户相关")
@RestController
@RequestMapping("user")
@Validated
@Slf4j
public class ChimeUserController {
    @Autowired
    private IChimeUserService chimeUserService;

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "社交用户注册")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "userId", value = "用户id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "nickname", value = "昵称"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "sex", value = "性别"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tags", value = "兴趣标签[{\"tagCode\":\"tag1\",\"tagDesc\":\"tag描述\"},{\"tagCode\":\"tag2\",\"tagDesc\":\"tag描述2\"}]"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "performanceId", value = "演出id")
    })
    @PostMapping(value = {"register"})
    public ResponseDto<String> register(@RequestParam @Validated String userId
            , @RequestParam @Validated String nickname
            , @RequestParam @Validated String sex
            , @RequestParam @Validated String tags
            , @RequestParam @Validated String performanceId
    ) {
        ChimeUserRegisterReqDto reqDto = ChimeUserRegisterReqDto.getNew();
        reqDto.setUserId(userId);
        reqDto.setNickName(nickname);
        reqDto.setSex(sex);
        reqDto.setTags(tags);
        if(StringUtil.isNotEmpty(performanceId)){
            reqDto.setPerformanceId(performanceId);
        }else{
            //云在场
            reqDto.setPerformanceId("-1");
        }
        ChimeUserInfoDto chimeUserInfoDto = chimeUserService.createChimeUserInfo(reqDto);
        if(StringUtil.isNull(chimeUserInfoDto)){
            return ResponseDto.failure("chime创建社交用户失败！");
        }
        return ResponseDto.success("创建成功！");
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "用户信息修改同步")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "userId", value = "用户id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "nickname", value = "昵称"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "sex", value = "性别"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tags", value = "兴趣标签(多个用逗号隔开)")
    })
    @PostMapping(value = {"updateUserTags"})
    public ResponseDto<Boolean> updateUserTags(@RequestParam @Validated String userId
            , @RequestParam @Validated String nickname
            , @RequestParam @Validated String sex
            , @RequestParam @Validated String tags
    ) {
        ChimeUserUpdateReqDto reqDto = ChimeUserUpdateReqDto.getNew();
        reqDto.setUserId(userId);
        reqDto.setNickName(nickname);
        reqDto.setSex(sex);
        reqDto.setTags(tags);
        //更新用户信息
        Boolean rs = chimeUserService.updateUserInfo(reqDto);
        return ResponseDto.success(rs);
    }

//    @GetMapping("getUserByUserId")
//    @ApiOperation("查询单个用户信息")
//    @ApiImplicitParams({
//            @ApiImplicitParam(type = "query", dataType = "String", name = "userId", value = "用户ID", required = true)
//    })
//    public ResponseDto<ChimeUserInfoDto> getUserByUserId(
//            @RequestParam(defaultValue = "") String userId
//    ) {
//        ChimeUserInfoDto userInfoDto = chimeUserService.getUserByUserId(userId);
//        return ResponseDto.success(userInfoDto);
//    }
}
