package com.liquidnet.service.chime.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.third.easemob.util.EasemobUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.chime.biz.ChimeUserBiz;
import com.liquidnet.service.chime.dto.ChimeUserInfoDto;
import com.liquidnet.service.chime.dto.ChimeUserRegisterReqDto;
import com.liquidnet.service.chime.dto.ChimeUserTagDto;
import com.liquidnet.service.chime.dto.ChimeUserUpdateReqDto;
import com.liquidnet.service.chime.service.IChimeUserService;
import com.liquidnet.service.chime.utils.DataUtils;
import com.liquidnet.service.chime.vo.mongo.ChimeUserInfoVo;
import com.liquidnet.service.chime.vo.mongo.ChimeUserTagsMappingVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserServiceImpl
 * @Package com.liquidnet.service.chime.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/8 16:17
 */
@Slf4j
@Service
public class ChimeUserServiceImpl implements IChimeUserService {
    @Autowired
    private EasemobUtil easemobUtil;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private ChimeUserBiz chimeUserBiz;

    @Override
    public JSONObject register(ChimeUserRegisterReqDto reqDto) {
        String result = easemobUtil.createUser(reqDto.getUserId(),"123456",reqDto.getNickName());
        log.info("chime easemobUtil.createUser result:{}",result);
        JSONObject jsonObject = JSONObject.parseObject(result);
        return jsonObject;
    }

    @Override
    public ChimeUserInfoDto createChimeUserInfo(ChimeUserRegisterReqDto reqDto) {
        try {
            String rk = AdamRedisConst.INFO_USER.concat(reqDto.getUserId());
            AdamUserInfoVo vo = (AdamUserInfoVo) redisUtil.get(rk);

            ChimeUserInfoDto chimeUserInfoDto = ChimeUserInfoDto.getNew();
            chimeUserInfoDto.setUserId(reqDto.getUserId());
            chimeUserInfoDto.setSex(reqDto.getSex());
            chimeUserInfoDto.setUserName(vo.getUid());
            chimeUserInfoDto.setUserMobile(vo.getMobile());
            chimeUserInfoDto.setAvatar(vo.getAvatar());
            chimeUserInfoDto.setJoinPerformanceId(reqDto.getPerformanceId());
            chimeUserInfoDto.setBirthday(vo.getBirthday());
            chimeUserInfoDto.setSignature(vo.getSignature());
            chimeUserInfoDto.setArea(vo.getArea());
            List<ChimeUserTagDto> userTagList = chimeUserBiz.buildUserTagDtoList(reqDto.getUserId(), reqDto.getTags());
            chimeUserInfoDto.setUserTags(userTagList);
            //插入mongo
            dataUtils.createChimeUser(chimeUserInfoDto);
            return chimeUserInfoDto;
        } catch (Exception e) {
            log.error("创建社交用户异常 e：{}",e.getMessage());
        }
        return null;
    }

    @Override
    public boolean updateUserInfo(ChimeUserUpdateReqDto reqDto) {
        try {
            String rk = AdamRedisConst.INFO_USER.concat(reqDto.getUserId());
            AdamUserInfoVo vo = (AdamUserInfoVo) redisUtil.get(rk);
            //插入userTagMapping
            ChimeUserInfoVo chimeUserInfoVo = ChimeUserInfoVo.getNew();
            BeanUtil.copy(reqDto,chimeUserInfoVo);
            chimeUserInfoVo.setUserName(vo.getUid());
            chimeUserInfoVo.setUserMobile(vo.getMobile());
            chimeUserInfoVo.setAvatar(vo.getAvatar());
            List<ChimeUserTagsMappingVo> userTagList = chimeUserBiz.buildUserTagVoList(reqDto.getUserId(),reqDto.getTags());
            chimeUserInfoVo.setUserTagsVoList(userTagList);
            dataUtils.updateChimeUser(chimeUserInfoVo);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("updateUserInfo error msg:{}",e.getMessage());
            log.error("updateUserInfo error info:{}",e);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateUserTags(ChimeUserUpdateReqDto reqDto) {
        //插入userTagMapping
        List<ChimeUserTagsMappingVo> userTagList = chimeUserBiz.buildUserTagVoList(reqDto.getUserId(),reqDto.getTags());
        return dataUtils.updateUserTagMapping(reqDto.getUserId(),userTagList);
    }

    @Override
    public ChimeUserInfoDto getUserByUserId(String userId) {
        ChimeUserInfoVo chimeUserInfoVo = dataUtils.getUserByUserId(userId);
        if(StringUtil.isNotNull(chimeUserInfoVo)){
            ChimeUserInfoDto chimeUserInfoDto = ChimeUserInfoDto.getNew();
            BeanUtil.copy(chimeUserInfoVo,chimeUserInfoDto);
            chimeUserInfoDto.setPassWord("123456");
            //获取标签
            chimeUserInfoDto.setUserTags(dataUtils.getUserTagList(userId));
            return chimeUserInfoDto;
        }
        return null;
    }

    @Override
    public boolean switchPerformanceId(String performanceId) {
        String userId = CurrentUtil.getCurrentUid();
        //获取社交用户
        ChimeUserInfoVo chimeUserInfoVo = dataUtils.getUserByUserId(userId);
        if(StringUtil.isNotNull(chimeUserInfoVo)){
            //判断演出id是否需要切换
            if(!chimeUserInfoVo.getJoinPerformanceId().equalsIgnoreCase(performanceId)){
                chimeUserInfoVo.setJoinPerformanceId(performanceId);
                dataUtils.updateChimeUser(chimeUserInfoVo);
            }
        }
        return true;
    }
}
