//package com.liquidnet.service.reconciliation.util.executor;
//
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang.StringUtils;
//
//import java.util.concurrent.*;
//import java.util.concurrent.atomic.AtomicInteger;
//
//@Slf4j
//public class NamedPoolExecutor {
//	private static final int EXECUTOR_KEEP_ALIVE_TIME = 60000;
//	private static final int EXECUTOR_MAXIMUM_POOL_SIZE = Math.min(10, Runtime.getRuntime().availableProcessors());
//	private static final int EXECUTOR_CORE_POOL_SIZE = 1;
//
//	private ExecutorService executorService = null;
//
//	private java.util.Queue<String> namedQueue = null;
//
//
//	public NamedPoolExecutor() {
//		this(16);
//	}
//
//	public NamedPoolExecutor(int size) {
//		executorService = new NamedThreadPoolExecutor(size, size,
//				0, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(), new NamedThreadFactory());
//
//		if (namedQueue == null) {
//			namedQueue = new ArrayBlockingQueue<String>(size * 2);
//		}
//	}
//
//	public static NamedPoolExecutor createNamedPoolExecutor(int size) {
//		return new NamedPoolExecutor(size);
//	}
//
//	public void execute(Runnable runnable) {
//		namedQueue.add(Thread.currentThread().getName());
//		this.executorService.execute(runnable);
//	}
//
//	public Future submit(Callable runnable) {
//		namedQueue.add(Thread.currentThread().getName());
//		return this.executorService.submit(runnable);
//	}
//
//	public void shutdown() {
//		this.executorService.shutdown();
//	}
//
//
//
//	static class NamedThreadFactory implements ThreadFactory {
//		private static final AtomicInteger poolNumber = new AtomicInteger(1);
//		private final ThreadGroup group;
//		private final AtomicInteger threadNumber = new AtomicInteger(1);
//
//		private final String poolNamePrefix;
//
//		NamedThreadFactory() {
//			SecurityManager s = System.getSecurityManager();
//			group = (s != null) ? s.getThreadGroup() :
//					Thread.currentThread().getThreadGroup();
//			poolNamePrefix = "p-" +
//					poolNumber.getAndIncrement() +
//					"-t-";
//		}
//
//		public Thread newThread(Runnable r) {
//			String threadName = Thread.currentThread().getName();
//			log.info(String.format("current name is %s", threadName));
//
//			String name = threadName + "-" + poolNamePrefix + threadNumber.getAndIncrement();
//			Thread t = new Thread(group, r, name
//					,
//					0);
//			if (t.isDaemon())
//				t.setDaemon(false);
//			if (t.getPriority() != Thread.NORM_PRIORITY)
//				t.setPriority(Thread.NORM_PRIORITY);
//			return t;
//		}
//	}
//
//
//
//	public class NamedThreadPoolExecutor extends ThreadPoolExecutor {
//		private BlockingQueue<Runnable> workQueue;
//		private Integer corePoolSize;
//		private Integer maximumPoolSize;
//		public NamedThreadPoolExecutor(int corePoolSize,
//								  int maximumPoolSize,
//								  long keepAliveTime,
//								  TimeUnit unit,
//								  BlockingQueue<Runnable> workQueue,
//								  ThreadFactory threadFactory) {
//			super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue,
//					threadFactory);
//			this.corePoolSize = corePoolSize;
//			this.maximumPoolSize = maximumPoolSize;
//			this.workQueue = workQueue;
//		}
//
//		protected void beforeExecute(Thread t, Runnable r) {
//
//			log.info(String.format("current name if %s", Thread.currentThread().getName()));
//
//			String name = namedQueue.poll();//存在问题,高并发下线程切换获取的并不是父线程名称
//
//			if (name != null) {
//				int nameIndex = t.getName().indexOf("-");
//				String subName = StringUtils.substring(t.getName(), nameIndex + 1);
//				t.setName(name + "-" + subName);
//			}
//
//			log.info(String.format("name if %s", t.getName()));
//
//			log.info(String.format("corePoolSize is %s, maximumPoolSize is %s, workQueue size %s", String.valueOf(corePoolSize), String.valueOf(maximumPoolSize), String.valueOf(workQueue.size())));
//		}
//
//	}
//
//
//}
