package com.liquidnet.service.feign.platform.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;

@Component
@FeignClient(
        name = "liquidnet-service-platform",
        contextId = "FeignPlatformGoblinTaskClient",
        path = "platform",
        url = "${liquidnet.service.platform.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignPlatformSmileTaskClient {


    @PostMapping("sell/sellData")
    public ResponseDto<Boolean> sellData();
    @PostMapping("sell/commissionData")
    public ResponseDto<Boolean> commissionData();
}
