package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinPerformancesAdminServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinRoadShowsAdminServiceImpl;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dao.RoadShowAdminListDao;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;


/**
 * 演出Controller
 *
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/performances/roadShow")
public class KylinRoadShowController extends BaseController {
    private String prefix = "zhengzai/kylin/performances/roadShow";

    @Autowired
    private KylinRoadShowsAdminServiceImpl kylinRoadShowsAdminService;

    @RequiresPermissions("kylin:performances:roadShow")
    @GetMapping()
    public String roadShow() {
        return prefix + "/roadShow";
    }

    @RequiresPermissions("kylin:performances:roadShow:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo listRoadShow(@RequestParam(value = "title",required = false) String title,
                                      @RequestParam(value = "pageNum") int page,
                                      @RequestParam(value = "pageSize") int size) {
        startPage();/**/
        PageInfo<RoadShowAdminListDao> result = kylinRoadShowsAdminService.listRoadShow(title, page, size);
        return getDataTable(result.getList());
    }
}

