package com.liquidnet.service.adam.controller;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.adam.dto.vo.AdamDisposedBaseVo;
import com.liquidnet.service.adam.dto.vo.AdamDisposedUserVo;
import com.liquidnet.service.adam.dto.vo.AdamDisposedVo;
import com.liquidnet.service.adam.service.IAdamDisposedService;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 收藏 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@ApiSupport(order = 10070)
@Api(tags = "想去")
@Slf4j
@RestController
@RequestMapping("disposed")
public class AdamDisposedController {
    @Autowired
    IAdamDisposedService adamDisposedService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加想去")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestParam String type, @RequestParam String contentId) {
        // TODO: 2021/4/28 数据校验
        String currentUid = CurrentUtil.getCurrentUid();

        AdamDisposedBaseVo existVo = adamDisposedService.query(currentUid, type, contentId);
        if (null != existVo) return ResponseDto.success();

        AdamDisposedBaseVo disposedBaseVo = AdamDisposedBaseVo.getNew();
        disposedBaseVo.setType(type);
        disposedBaseVo.setContentId(contentId);
        disposedBaseVo.setUid(currentUid);

        adamDisposedService.add(disposedBaseVo);

        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "删除想去")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "收藏类型", allowableValues = "TICKET"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "contentIds", value = "内容ID[多个ID用','分隔]"),
    })
    @PostMapping("del")
    public ResponseDto<Object> del(@RequestParam String type, @RequestParam String contentIds) {
        // TODO: 2021/4/28 数据校验

        adamDisposedService.del(CurrentUtil.getCurrentUid(), type, contentIds.split(","));

        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "想去列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "收藏类型", allowableValues = "TICKET"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "pageNo", value = "页码", example = "1"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "pageSize", value = "页展示条数", example = "5"),
    })
    @PostMapping("list")
    public ResponseDto<PageInfo<AdamDisposedVo>> list(@RequestParam String type,
                                                      @RequestParam(defaultValue = "1", required = false) int pageNo,
                                                      @RequestParam(defaultValue = "5", required = false) int pageSize) {
        // TODO: 2021/4/28 数据校验

        pageNo = pageNo > 0 ? pageNo : 1;
        pageSize = pageSize <= 0 || pageSize > 10 ? 10 : pageSize;

        return ResponseDto.success(adamDisposedService.queryPage(CurrentUtil.getCurrentUid(), type, pageNo, pageSize));
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "想去用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "收藏类型", allowableValues = "TICKET"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "contentId", value = "内容ID[64]"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "pageNo", value = "页码", example = "1"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "pageSize", value = "页展示条数", example = "10"),
    })
    @PostMapping("list/user")
    public ResponseDto<PageInfo<AdamDisposedUserVo>> listUser(@RequestParam String type, @RequestParam String contentId,
                                                              @RequestParam(defaultValue = "1", required = false) int pageNo,
                                                              @RequestParam(defaultValue = "10", required = false) int pageSize) {
        // TODO: 2021/4/28 数据校验

        pageNo = pageNo > 0 ? pageNo : 1;
        pageSize = pageSize <= 0 || pageSize > 20 ? 20 : pageSize;

        return ResponseDto.success(adamDisposedService.queryDisposedUsers(type, contentId, pageNo, pageSize));
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "获取想去状态")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "收藏类型", allowableValues = "TICKET"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "contentId", value = "内容ID[64]"),
    })
    @GetMapping("state")
    public ResponseDto<Boolean> state(@RequestParam String type, @RequestParam String contentId) {
        // TODO: 2021/4/28 数据校验
        return ResponseDto.success(adamDisposedService.queryState(CurrentUtil.getCurrentUid(), type, contentId));
    }
}
