package com.liquidnet.service.kylin.controller.partner;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.TicketCreateParam;
import com.liquidnet.service.kylin.dto.vo.partner.TicketPartnerVo;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketsPartnerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 票 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Api(tags = "第三方-票")
@RestController
@RequestMapping("partner/ticket")
public class KylinTicketsPartnerController {

    @Autowired
    private KylinTicketsPartnerServiceImpl ticketsPartnerService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建票务")
    @ApiResponse(response = TicketPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<TicketPartnerVo> createTicketSummary(@RequestBody TicketCreateParam ticketCreateParam) {
        return ticketsPartnerService.createTicketSummary(ticketCreateParam);
    }

    @PutMapping(value = "")
    @ApiOperation(value = "修改票务")
    @ApiResponse(response = TicketPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<TicketPartnerVo> updateTicket(@RequestBody TicketCreateParam ticketCreateParam) {
        return ticketsPartnerService.updateTicket(ticketCreateParam);
    }

    @DeleteMapping(value = "")
    @ApiOperation(value = "删除票务")
    @ApiResponse( code = 200, message = "接口返回对象参数")
    public ResponseDto<String> deleteTicket(@RequestParam("ticketsId") String ticketsId) {
        return ticketsPartnerService.deleteTicket(ticketsId);
    }

    @PostMapping(value = "/copy")
    @ApiOperation(value = "复制票务")
    @ApiResponse(response = TicketPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<TicketPartnerVo> copyTicket(@RequestParam("ticketsId") String ticketsId) {
        return ticketsPartnerService.copyTicket(ticketsId);
    }

    @GetMapping(value = "/details")
    @ApiOperation(value = "获取票务详情")
    @ApiResponse(response = TicketPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<TicketPartnerVo> getTicketsMongo(@RequestParam("ticketsId") String ticketsId) {
        TicketPartnerVo result = null;
        result = ticketsPartnerService.getTicketsMongo(ticketsId);
        if (null == result) {
            return ResponseDto.failure("查询票务信息失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @PostMapping(value = "/onLine")
    @ApiOperation(value = "票上线")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> onLine(@RequestParam("ticketsId") String ticketsId) {
        return ticketsPartnerService.onLine(ticketsId);
    }

    @PostMapping(value = "/outLine")
    @ApiOperation(value = "票下线")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> outLine(@RequestParam("ticketsId") String ticketsId) {
        return ticketsPartnerService.outLine(ticketsId);
    }
}
