package com.liquidnet.service.order.controller;


import com.alibaba.fastjson.JSONObject;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.annotation.DecryptAndVerify;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.kylin.dto.param.PayAgainParam;
import com.liquidnet.service.kylin.dto.param.PayOrderParam;
import com.liquidnet.service.kylin.dto.param.SyncOrderParam;
import com.liquidnet.service.kylin.dto.vo.returns.*;
import com.liquidnet.service.kylin.service.IKylinOrderTicketsOrderService;
import com.liquidnet.service.order.utils.ObjectUtil;
import com.liquidnet.service.order.utils.OrderUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.HashMap;

/**
 * <p>
 * 订单 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Api(tags = "前端-订单相关")
@RestController
@RequestMapping("order")
@Validated
@Slf4j
public class KylinOrderTicketsController {

    @Autowired
    IKylinOrderTicketsOrderService orderTicketsOrderService;

    @PostMapping("fc7bce6d6c2213b866f76493f92224b7")
    @ApiOperation("fc7bce6d6c2213b866f76493f92224b7")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PayInnerResultVo> checkCanOrder(@RequestBody @Valid PayOrderParam payOrderParam) {
        return orderTicketsOrderService.checkCanOrder(payOrderParam);
    }

    @DecryptAndVerify(decryptedClass = PayOrderParam.class)
    @PostMapping("pre")
    @ApiOperation("下单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PayInnerResultVo> checkCanOrder(@RequestBody @Valid EncryptedReq<PayOrderParam> encryptedReq) {
        PayOrderParam payOrderParam = encryptedReq.getData();
        return orderTicketsOrderService.checkCanOrder(payOrderParam);
    }

    @PostMapping("payAgain")
    @ApiOperation("再次支付")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PayInnerResultVo> payAgain(@RequestBody @Valid PayAgainParam payAgainParam) {
        ResponseDto<PayInnerResultVo> rsp = orderTicketsOrderService.payAgain(payAgainParam);
        log.info("payAgain log = {}", JSONObject.toJSONString(rsp));
        PayInnerResultVo vo = rsp.getData();
        if (null == vo) {
            return ResponseDto.failure(ErrorMapping.get("20024"));
        } else {
            return ResponseDto.success(vo);
        }
    }

    @PostMapping("syncOrder")
    @ApiOperation("支付回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public String syncOrder(@ModelAttribute @Valid SyncOrderParam syncOrderParam) {
        return orderTicketsOrderService.syncOrder(syncOrderParam);
    }

    @Autowired
    OrderUtils orderUtils;

    @GetMapping("checkPayment")
    @ApiOperation("订单状态")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<HashMap> checkOrderResult(@RequestParam("orderId") @NotNull(message = "订单ID不能为空") String orderId) {
        Integer status = orderTicketsOrderService.checkOrderResult(orderId).getData();
        if (null == status) {
            return ResponseDto.failure(ErrorMapping.get("20003"));
        } else {
            HashMap<String, Integer> map = ObjectUtil.cloneHashMapStringAndInteger();
            map.put("status", status);
            return ResponseDto.success(map);
        }
    }
}
